/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.network.messages.server.CreateColonyMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WindowTownHallColonyManage
extends AbstractWindowSkeleton {
    private static final String BUTTON_CREATE = "create";
    private final BlockPos pos;
    private final boolean reactivate;

    public WindowTownHallColonyManage(BlockPos pos, String closestName, int closestDistance, String preName, boolean reactivate) {
        super("minecolonies:gui/townhall/windowcolonymanagement.xml");
        this.pos = pos;
        this.reactivate = reactivate;
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
        this.registerButton("cancel", this::close);
        this.registerButton(BUTTON_CREATE, this::onCreate);
        ((TextField)this.findPaneOfTypeByID("colonyname", TextField.class)).setText(preName.isEmpty() ? Component.translatable((String)"com.minecolonies.coremod.gui.townhall.defaultname", (Object[])new Object[]{this.mc.player.getName()}).getString() : preName);
        ((Text)this.findPaneOfTypeByID("text1", Text.class)).setText(Component.translatable((String)"com.minecolonies.core.settlementcovenant1", (Object[])new Object[]{Math.max(13L, Minecraft.getInstance().level.getGameTime() / 20L / 60L / 100L)}));
        if (closestDistance < 1000) {
            ((Text)this.findPaneOfTypeByID("text3", Text.class)).setText(Component.translatable((String)"com.minecolonies.core.settlementcovenant3.hasclose", (Object[])new Object[]{Component.literal((String)closestName).withStyle(ChatFormatting.RED), Component.literal((String)String.valueOf(closestDistance)).withStyle(ChatFormatting.RED)}));
        } else {
            ((Text)this.findPaneOfTypeByID("text3", Text.class)).setText(Component.translatable((String)"com.minecolonies.core.settlementcovenant3.noclose"));
        }
    }

    public void onCreate() {
        String colonyName = ((TextField)this.findPaneOfTypeByID("colonyname", TextField.class)).getText();
        new VanillaParticleMessage(this.pos.getX(), this.pos.getY(), this.pos.getZ(), ParticleTypes.DRAGON_BREATH).onExecute(null, (Player)this.mc.player);
        Minecraft.getInstance().level.playSound((Player)Minecraft.getInstance().player, Minecraft.getInstance().player.blockPosition(), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.AMBIENT, 2.5f, 0.8f);
        BlockEntity entity = Minecraft.getInstance().level.getBlockEntity(this.pos);
        new CreateColonyMessage(this.pos, this.reactivate, colonyName, this.reactivate ? "" : StructurePacks.selectedPack.getName(), ((TileEntityColonyBuilding)entity).getBlueprintPath()).sendToServer();
        this.close();
    }
}

