/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.core.tileentities.TileEntityNamedGrave;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityNamedGraveRenderer
implements BlockEntityRenderer<TileEntityNamedGrave> {
    private static final int BASIC_ROTATION = 90;
    private static final int ROTATE_EAST = 1;
    private static final int ROTATE_NORTH = 2;
    private static final int ROTATE_WEST = 3;

    public TileEntityNamedGraveRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(@NotNull TileEntityNamedGrave tileEntity, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BlockState state;
        matrixStack.pushPose();
        if (tileEntity != null && (state = tileEntity.getLevel().getBlockState(tileEntity.getBlockPos())).getBlock() == ModBlocks.blockNamedGrave) {
            Direction facing = (Direction)state.getValue((Property)AbstractBlockMinecoloniesDefault.FACING);
            switch (facing) {
                case NORTH: {
                    matrixStack.translate(0.5f, 1.18f, 0.48f);
                    matrixStack.scale(0.006f, -0.006f, 0.006f);
                    matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                    break;
                }
                case SOUTH: {
                    matrixStack.translate(0.5f, 1.18f, 0.54f);
                    matrixStack.scale(0.006f, -0.006f, 0.006f);
                    break;
                }
                case EAST: {
                    matrixStack.translate(0.54f, 1.18f, 0.5f);
                    matrixStack.scale(0.006f, -0.006f, 0.006f);
                    matrixStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                    break;
                }
                case WEST: {
                    matrixStack.translate(0.48f, 1.18f, 0.5f);
                    matrixStack.scale(0.006f, -0.006f, 0.006f);
                    matrixStack.mulPose(Axis.YP.rotationDegrees(270.0f));
                }
            }
            if (tileEntity.getTextLines().isEmpty()) {
                this.renderText(matrixStack, buffer, combinedLight, "Unknown Citizen", 0);
            } else {
                for (int i = 0; i < tileEntity.getTextLines().size(); ++i) {
                    this.renderText(matrixStack, buffer, combinedLight, tileEntity.getTextLines().get(i), i);
                }
            }
        }
        matrixStack.popPose();
    }

    private void renderText(PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, String text, int line) {
        FormattedCharSequence iReorderingProcessor;
        int maxSize = 20;
        if (text.length() > 20) {
            text = text.substring(0, 20);
        }
        if ((iReorderingProcessor = FormattedCharSequence.forward((String)text, (Style)Style.EMPTY)) != null) {
            Font fontRenderer = Minecraft.getInstance().font;
            float x = -fontRenderer.width(iReorderingProcessor) / 2;
            fontRenderer.drawInBatch(iReorderingProcessor, x, (float)line * 10.0f, -589505536, false, matrixStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        }
    }

    public boolean shouldRenderOffScreen(TileEntityNamedGrave tileEntityMBE21) {
        return false;
    }
}

