/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.jobs.IJob;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class AnimalHerdingModule
extends AbstractBuildingModule {
    private final JobEntry jobEntry;
    private final Predicate<Animal> animalPredicate;
    private final ItemStack breedingItem;

    public AnimalHerdingModule(@NotNull JobEntry jobEntry, @NotNull Predicate<Animal> animalPredicate, @NotNull ItemStack breedingItem) {
        this.jobEntry = jobEntry;
        this.animalPredicate = animalPredicate;
        this.breedingItem = breedingItem;
    }

    @NotNull
    public IJob<?> getHerdingJob() {
        return this.jobEntry.produceJob(null);
    }

    public boolean isCompatible(@NotNull Animal animal) {
        return this.animalPredicate.test(animal);
    }

    @NotNull
    public List<ItemStack> getBreedingItems() {
        return Collections.singletonList(this.breedingItem);
    }

    public List<ResourceKey<LootTable>> getLootTables(@NotNull Animal animal) {
        return Collections.singletonList(animal.getLootTable());
    }

    @NotNull
    public List<IGenericRecipe> getRecipesForDisplayPurposesOnly(@NotNull Animal animal) {
        return Collections.singletonList(new GenericRecipe(BuiltInRegistries.ENTITY_TYPE.getKey((Object)animal.getType()), ItemStack.EMPTY, Collections.emptyList(), Collections.emptyList(), Collections.singletonList(this.getBreedingItems()), 0, Blocks.AIR, (ResourceKey<LootTable>)animal.getLootTable(), (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), animal.getType(), Collections.emptyList(), 0));
    }
}

