/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.fields.IField;
import com.minecolonies.core.util.CollectorUtils;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FieldsModule
extends AbstractBuildingModule
implements IPersistentModule,
IBuildingModule {
    private static final String TAG_ASSIGN_MANUALLY = "assign";
    private final Map<IField, Instant> checkedFields = new HashMap<IField, Instant>();
    @Nullable
    private IField currentField;
    private boolean shouldAssignManually = false;

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.shouldAssignManually = compound.getBoolean(TAG_ASSIGN_MANUALLY);
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        compound.putBoolean(TAG_ASSIGN_MANUALLY, this.shouldAssignManually);
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.shouldAssignManually);
        buf.writeInt(this.getMaxFieldCount());
    }

    protected abstract int getMaxFieldCount();

    public abstract Class<?> getExpectedFieldType();

    @Nullable
    public IField getCurrentField() {
        return this.currentField;
    }

    @Nullable
    public IField getFieldToWorkOn() {
        if (this.currentField != null) {
            return this.currentField;
        }
        Instant now = Instant.now();
        for (IField field : this.getOwnedFields().stream().collect(CollectorUtils.toShuffledList())) {
            if (this.checkedFields.containsKey(field) && !now.isAfter(this.checkedFields.get(field))) continue;
            this.checkedFields.remove(field);
            this.currentField = field;
            return field;
        }
        return null;
    }

    @NotNull
    public final List<IField> getOwnedFields() {
        return this.getFields().stream().filter(f -> this.building.getID().equals((Object)f.getBuildingId())).toList();
    }

    @NotNull
    public abstract List<IField> getFields();

    public void claimFields() {
        if (!this.shouldAssignManually) {
            for (IField field : this.getFreeFields()) {
                this.assignField(field);
            }
        }
    }

    public final List<IField> getFreeFields() {
        return this.getFields().stream().filter(field -> !field.isTaken()).toList();
    }

    public void assignField(IField field) {
        if (this.canAssignField(field)) {
            field.setBuilding(this.building.getID());
            this.markDirty();
        }
    }

    public final boolean canAssignField(IField field) {
        return this.getOwnedFields().size() < this.getMaxFieldCount() && this.canAssignFieldOverride(field);
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.building.getColony().getBuildingManager().markFieldsDirty();
    }

    protected abstract boolean canAssignFieldOverride(IField var1);

    public final boolean assignManually() {
        return this.shouldAssignManually;
    }

    public final boolean hasNoFields() {
        return this.getOwnedFields().isEmpty();
    }

    public final void setAssignManually(boolean assignManually) {
        this.shouldAssignManually = assignManually;
    }

    public void freeField(IField field) {
        field.resetOwningBuilding();
        this.markDirty();
        if (Objects.equals(this.currentField, field)) {
            this.resetCurrentField();
        }
    }

    public void resetCurrentField() {
        if (this.currentField != null) {
            this.checkedFields.put(this.currentField, Instant.now().plus((long)this.getFieldCheckTimeoutSeconds(), ChronoUnit.SECONDS));
        }
        this.currentField = null;
    }

    protected abstract int getFieldCheckTimeoutSeconds();
}

