/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.OptionalPredicate;
import com.minecolonies.api.util.constant.TagConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.util.FurnaceRecipes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingKitchen
extends AbstractBuilding {
    private static final String KITCHEN_DESC = "kitchen";
    private static final int MAX_BUILDING_LEVEL = 5;

    public BuildingKitchen(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return KITCHEN_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_COOK).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            return CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_COOK).orElse(FoodUtils.EDIBLE.test(recipe.getPrimaryOutput()));
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Crafting {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public OptionalPredicate<ItemStack> getIngredientValidator() {
            return CraftingUtils.getIngredientValidatorBasedOnTags(TagConstants.CRAFTING_COOK).combine(super.getIngredientValidator());
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            if (!super.isRecipeCompatible(recipe)) {
                return false;
            }
            Optional<Boolean> isRecipeAllowed = CraftingUtils.isRecipeCompatibleBasedOnTags(recipe, TagConstants.CRAFTING_COOK);
            if (isRecipeAllowed.isPresent()) {
                return isRecipeAllowed.get();
            }
            ItemStack output = recipe.getPrimaryOutput();
            return FoodUtils.EDIBLE.test(output) || FoodUtils.EDIBLE.test(FurnaceRecipes.getInstance().getSmeltingResult(output));
        }
    }
}

