/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.MinimumStockModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class BuildingNetherWorker
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> CLOSE_PORTAL = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "closeportal"));
    private static final String NETHER_WORKER = "netherworker";
    private static final String TAG_CURRENT_TRIPS = "current_trips";
    private static final String TAG_CURRENT_DAY = "current_day";
    private static final int MAX_PER_PERIOD = 1;
    private static final int PERIOD_DAYS = 3;
    public static final String FOOD_EXCLUSION_LIST = "food";
    private int currentPeriodDay = 0;
    private int currentTrips = 0;
    private long snapTime;

    public BuildingNetherWorker(@NotNull IColony colony, BlockPos pos) {
        super(colony, pos);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.sword.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> itemStack.getItem() instanceof FlintAndSteelItem, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.getItem() instanceof ArmorItem && ((ArmorItem)itemStack.getItem()).getEquipmentSlot() == EquipmentSlot.HEAD, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.getItem() instanceof ArmorItem && ((ArmorItem)itemStack.getItem()).getEquipmentSlot() == EquipmentSlot.CHEST, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.getItem() instanceof ArmorItem && ((ArmorItem)itemStack.getItem()).getEquipmentSlot() == EquipmentSlot.LEGS, new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> !ItemStackUtils.isEmpty(itemStack) && itemStack.getItem() instanceof ArmorItem && ((ArmorItem)itemStack.getItem()).getEquipmentSlot() == EquipmentSlot.FEET, new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return NETHER_WORKER;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public boolean shallClosePortalOnReturn() {
        return this.getSetting(CLOSE_PORTAL).getValue();
    }

    @Override
    public void onWakeUp() {
        super.onWakeUp();
        this.snapTime = this.colony.getWorld().getDayTime();
        if (this.currentPeriodDay < BuildingNetherWorker.getPeriodDays()) {
            ++this.currentPeriodDay;
        } else {
            this.currentPeriodDay = 0;
            this.currentTrips = 0;
        }
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains(TAG_CURRENT_TRIPS)) {
            this.currentTrips = compound.getInt(TAG_CURRENT_TRIPS);
        }
        if (compound.contains(TAG_CURRENT_DAY)) {
            this.currentPeriodDay = compound.getInt(TAG_CURRENT_DAY);
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putInt(TAG_CURRENT_TRIPS, this.currentTrips);
        compound.putInt(TAG_CURRENT_DAY, this.currentPeriodDay);
        return compound;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory, JobEntry jobEntry) {
        if (stack.isEmpty()) {
            return 0;
        }
        if (inventory && ((MinimumStockModule)this.getFirstModuleOccurance(MinimumStockModule.class)).isStocked(stack)) {
            return stack.getCount();
        }
        IRecipeStorage rs = ((CraftingModule)this.getFirstModuleOccurance(CraftingModule.class)).getFirstRecipe(ItemStack::isEmpty);
        if (rs != null) {
            ItemStorage kept = new ItemStorage(stack);
            boolean containsItem = rs.getInput().contains(kept);
            int keptCount = localAlreadyKept.stream().filter(storage -> storage.equals(kept)).mapToInt(ItemStorage::getAmount).sum();
            if (containsItem && (keptCount < 64 || !inventory)) {
                if (localAlreadyKept.contains(kept)) {
                    kept.setAmount(localAlreadyKept.remove(localAlreadyKept.indexOf(kept)).getAmount());
                }
                localAlreadyKept.add(kept);
                return 0;
            }
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory, jobEntry);
    }

    public boolean isReadyForTrip() {
        if (this.snapTime == 0L) {
            this.snapTime = this.colony.getWorld().getDayTime();
        }
        if (Math.abs(this.colony.getWorld().getDayTime() - this.snapTime) >= 24000L) {
            ++this.currentPeriodDay;
        }
        return this.currentTrips < BuildingNetherWorker.getMaxPerPeriod();
    }

    public void recordTrip() {
        ++this.currentTrips;
    }

    public BlockPos getPortalLocation() {
        BlockPos portalLocation = this.getFirstLocationFromTag("portal");
        if (portalLocation != null) {
            return portalLocation.above();
        }
        return null;
    }

    public BlockPos getVaultLocation() {
        return this.getFirstLocationFromTag("vault");
    }

    public static int getMaxPerPeriod() {
        return 1;
    }

    public static int getPeriodDays() {
        return 3;
    }

    @Override
    public void onPlacement() {
        super.onPlacement();
        Level world = this.colony.getWorld();
        if (WorldUtil.isNetherType(world)) {
            Block block = world.getBlockState(this.getPosition()).getBlock();
            block.destroy((LevelAccessor)world, this.getPosition(), world.getBlockState(this.getPosition()));
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }
    }
}

