/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.GenericRecipe;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.RecipeStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.crafting.CustomRecipe;
import com.minecolonies.core.util.FurnaceRecipes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.NotNull;

public class BuildingSmeltery
extends AbstractBuilding {
    private static final String SMELTERY_DESC = "smeltery";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final int STUFF_TO_KEEP = 10;

    public BuildingSmeltery(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(IColonyManager.getInstance().getCompatibilityManager()::isOre, new Tuple((Object)Integer.MAX_VALUE, (Object)true));
        this.keepX.put(stack -> !ItemStackUtils.isEmpty(stack) && (stack.getItem() instanceof SwordItem || stack.getItem() instanceof DiggerItem || stack.getItem() instanceof ArmorItem), new Tuple((Object)10, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SMELTERY_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    public static class OreBreakingModule
    extends AbstractCraftingBuildingModule.Custom {
        public OreBreakingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        @NotNull
        public List<ResourceKey<LootTable>> getAdditionalLootTables() {
            ArrayList<ResourceKey<LootTable>> lootTables = new ArrayList<ResourceKey<LootTable>>(super.getAdditionalLootTables());
            for (Holder input : BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.breakable_ore)) {
                lootTables.add(this.getLootTable((Item)input.value()));
            }
            return lootTables;
        }

        @Override
        protected boolean isPreTaughtRecipe(IRecipeStorage storage, Map<ResourceLocation, CustomRecipe> crafterRecipes) {
            if (storage.getPrimaryOutput().isEmpty() && storage.getLootTable() != null) {
                return true;
            }
            return super.isPreTaughtRecipe(storage, crafterRecipes);
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            for (Holder input : BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.breakable_ore)) {
                recipes.add(new GenericRecipe(null, ItemStack.EMPTY, Collections.emptyList(), Collections.singletonList(Collections.singletonList(new ItemStack(input))), 1, Blocks.AIR, this.getLootTable((Item)input.value()), (EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), Collections.emptyList(), -1));
            }
            return recipes;
        }

        @Override
        public void checkForWorkerSpecificRecipes() {
            super.checkForWorkerSpecificRecipes();
            for (Holder input : BuiltInRegistries.ITEM.getTagOrEmpty(ModTags.breakable_ore)) {
                Block b = Block.byItem((Item)((Item)input.value()));
                List drops = Block.getDrops((BlockState)b.defaultBlockState(), (ServerLevel)((ServerLevel)this.building.getColony().getWorld()), (BlockPos)this.building.getID(), null);
                for (ItemStack drop : drops) {
                    if (drop.isEmpty()) continue;
                    drop.setCount(1);
                }
                RecipeStorage tempRecipe = StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(new ItemStorage(new ItemStack(input))), 1, ItemStack.EMPTY, null, null, null, null, drops, this.getLootTable((Item)input.value())});
                IToken<?> token = IColonyManager.getInstance().getRecipeManager().checkOrAddRecipe(tempRecipe);
                this.addRecipeToList(token, false);
            }
        }

        @Override
        public ItemStack getCraftingTool(AbstractEntityCitizen worker) {
            ItemStack pick = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
            int fortuneLevel = this.building.getBuildingLevel() - 1;
            if (fortuneLevel > 0) {
                pick.enchant(Utils.getRegistryValue(Enchantments.FORTUNE, worker.level()), fortuneLevel);
            }
            return pick;
        }

        protected ResourceKey<LootTable> getLootTable(Item item) {
            if (item instanceof BlockItem) {
                Block itemBlock = Block.byItem((Item)item);
                return itemBlock.getLootTable();
            }
            return null;
        }
    }

    public static class SmeltingModule
    extends AbstractCraftingBuildingModule.Smelting {
        public SmeltingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean isRecipeCompatible(@NotNull IGenericRecipe recipe) {
            return false;
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        @NotNull
        public List<IGenericRecipe> getAdditionalRecipesForDisplayPurposesOnly(@NotNull Level world) {
            ArrayList<IGenericRecipe> recipes = new ArrayList<IGenericRecipe>(super.getAdditionalRecipesForDisplayPurposesOnly(world));
            ICompatibilityManager compatibility = IColonyManager.getInstance().getCompatibilityManager();
            for (ItemStack stack : compatibility.getListOfAllItems()) {
                if (!ItemStackUtils.IS_SMELTABLE.and(compatibility::isOre).and(s -> !s.is(ModTags.breakable_ore)).test(stack)) continue;
                ItemStack output = FurnaceRecipes.getInstance().getSmeltingResult(stack);
                recipes.add(SmeltingModule.createSmeltingRecipe(new ItemStorage(stack), output, Blocks.FURNACE));
            }
            return recipes;
        }

        private static IGenericRecipe createSmeltingRecipe(ItemStorage input, ItemStack output, Block intermediate) {
            return GenericRecipe.of(StandardFactoryController.getInstance().getNewInstance(TypeConstants.RECIPE, StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new Object[]{Collections.singletonList(input), 1, output, intermediate}));
        }
    }
}

