/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.crafting.ToolUsage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class ToolsAnalyzer {
    @NotNull
    public static List<ToolUsage> findTools(Level level) {
        HashMap<EquipmentTypeEntry, ToolUsage> toolItems = new HashMap<EquipmentTypeEntry, ToolUsage>();
        for (ItemStack stack : IColonyManager.getInstance().getCompatibilityManager().getListOfAllItems()) {
            for (EquipmentTypeEntry toolType : ModEquipmentTypes.getRegistry()) {
                if (toolType == ModEquipmentTypes.none.get() || !toolType.checkIsEquipment(stack)) continue;
                ToolsAnalyzer.tryAddingToolWithLevel(toolItems, toolType, stack);
                if (!stack.isEnchantable()) continue;
                for (int enchantLevel = 1; enchantLevel < 4; ++enchantLevel) {
                    ToolsAnalyzer.tryAddingEnchantedTool(toolItems, toolType, stack, enchantLevel, level);
                }
            }
        }
        return toolItems.values().stream().sorted(Comparator.comparing(ToolUsage::tool, new EquipmentTypeEntry.Comparator())).toList();
    }

    private static void tryAddingEnchantedTool(@NotNull Map<EquipmentTypeEntry, ToolUsage> toolItems, @NotNull EquipmentTypeEntry tool, @NotNull ItemStack stack, int enchantLevel, Level level) {
        ItemStack enchantedStack = stack.copy();
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Utils.getRegistryValue(Enchantments.UNBREAKING, level), enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Utils.getRegistryValue(Enchantments.LOOTING, level), enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Utils.getRegistryValue(Enchantments.FLAME, level), enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Utils.getRegistryValue(Enchantments.FORTUNE, level), enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Utils.getRegistryValue(Enchantments.PROTECTION, level), enchantLevel);
        ToolsAnalyzer.tryEnchantStack(enchantedStack, Utils.getRegistryValue(Enchantments.LURE, level), enchantLevel);
        ToolsAnalyzer.tryAddingToolWithLevel(toolItems, tool, enchantedStack);
    }

    private static void tryEnchantStack(@NotNull ItemStack stack, @NotNull Holder<Enchantment> enchantment, int enchantLevel) {
        if (((Enchantment)enchantment.value()).canEnchant(stack) && enchantLevel >= ((Enchantment)enchantment.value()).getMinLevel() && enchantLevel <= ((Enchantment)enchantment.value()).getMaxLevel()) {
            stack.enchant(enchantment, enchantLevel);
        }
    }

    private static void tryAddingToolWithLevel(@NotNull Map<EquipmentTypeEntry, ToolUsage> toolItems, @NotNull EquipmentTypeEntry tool, @NotNull ItemStack stack) {
        int level = tool.getMiningLevel(stack);
        if (level < 0) {
            return;
        }
        level = Math.min(5, level + ItemStackUtils.getMaxEnchantmentLevel(stack));
        ToolUsage usage = toolItems.computeIfAbsent(tool, ToolUsage::create);
        if (stack.isEnchanted()) {
            usage.enchantedToolLevels().get(level).add(stack);
        } else {
            usage.toolLevels().get(level).add(stack);
        }
    }
}

