/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.eventhooks.buildingEvents;

import com.minecolonies.api.colony.colonyEvents.descriptions.IBuildingEventDescription;
import com.minecolonies.api.util.BlockPosUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractBuildingEvent
implements IBuildingEventDescription {
    private BlockPos eventPos;
    private String buildingName;
    private int level;

    public AbstractBuildingEvent() {
    }

    public AbstractBuildingEvent(BlockPos eventPos, String buildingName, int buildingLevel) {
        this.eventPos = eventPos;
        this.buildingName = buildingName;
        this.level = buildingLevel;
    }

    @Override
    public BlockPos getEventPos() {
        return this.eventPos;
    }

    @Override
    public void setEventPos(BlockPos pos) {
        this.eventPos = pos;
    }

    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        BlockPosUtil.write(compound, "eventPos", this.eventPos);
        compound.putString("buildingName", this.buildingName);
        compound.putInt("buildingLevel", this.level);
        return compound;
    }

    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        this.eventPos = BlockPosUtil.read(compound, "eventPos");
        this.buildingName = compound.getString("buildingName");
        this.level = compound.getInt("buildingLevel");
    }

    @Override
    public void serialize(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.eventPos);
        buf.writeUtf(this.buildingName);
        buf.writeInt(this.level);
    }

    @Override
    public void deserialize(RegistryFriendlyByteBuf buf) {
        this.eventPos = buf.readBlockPos();
        this.buildingName = buf.readUtf();
        this.level = buf.readInt();
    }

    @Override
    public String getBuildingName() {
        return this.buildingName;
    }

    @Override
    public void setBuildingName(String buildingName) {
        this.buildingName = buildingName;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int lvl) {
        this.level = lvl;
    }

    public String toString() {
        return this.toDisplayString();
    }
}

