/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.pirateEvent;

import com.google.common.collect.Lists;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipSize;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public final class ShipBasedRaiderUtils {
    public static final String SHIP_FOLDER = "/ships/";
    private static final int SPAWNER_DISTANCE = 30;

    private ShipBasedRaiderUtils() {
    }

    public static boolean spawnPirateShip(BlockPos targetSpawnPoint, IColony colony, Blueprint blueprint, IColonyRaidEvent event) {
        return colony.getEventManager().getStructureManager().spawnTemporaryStructure(blueprint, targetSpawnPoint, event.getID());
    }

    public static void setupSpawner(BlockPos location, Level world, EntityType<?> mob, IColonyRaidEvent event, int colonyId) {
        world.removeBlock(location, false);
        world.setBlockAndUpdate(location, Blocks.SPAWNER.defaultBlockState());
        SpawnerBlockEntity spawner = new SpawnerBlockEntity(location, Blocks.SPAWNER.defaultBlockState());
        spawner.getSpawner().requiredPlayerRange = 30;
        spawner.getSpawner().setEntityId(mob, world, world.getRandom(), location);
        spawner.getSpawner().nextSpawnData.getEntityToSpawn().putInt("mc_event_id", event.getID());
        spawner.getSpawner().nextSpawnData.getEntityToSpawn().putInt("colony", colonyId);
        event.addSpawner(location);
        world.setBlockEntity((BlockEntity)spawner);
    }

    public static boolean canSpawnShipAt(IColony colony, BlockPos spawnPoint, int raidLevel, RotationMirror rotMir, String shipName) {
        return ShipBasedRaiderUtils.canSpawnShipAt(colony, spawnPoint, raidLevel, rotMir, shipName, 3);
    }

    public static boolean canSpawnShipAt(IColony colony, BlockPos spawnPoint, int raidLevel, RotationMirror rotMir, String shipName, int neededDepth) {
        if (spawnPoint.equals((Object)colony.getCenter())) {
            return false;
        }
        Level world = colony.getWorld();
        String shipSize = ShipSize.getShipForRaiderAmount((int)raidLevel).schematicPrefix + shipName;
        Blueprint blueprint = StructurePacks.getBlueprint((String)"Minecolonies Original", (String)("decorations/ships/" + shipSize + ".blueprint"), (HolderLookup.Provider)colony.getWorld().registryAccess());
        blueprint.setRotationMirror(rotMir, world);
        return ShipBasedRaiderUtils.canPlaceShipAt(spawnPoint, blueprint, world, neededDepth) || ShipBasedRaiderUtils.canPlaceShipAt(spawnPoint.below(), blueprint, world, neededDepth);
    }

    public static boolean canPlaceShipAt(BlockPos pos, Blueprint ship, Level world) {
        return ShipBasedRaiderUtils.canPlaceShipAt(pos, ship, world, 3);
    }

    public static boolean canPlaceShipAt(BlockPos pos, Blueprint ship, Level world, int neededDepth) {
        BlockPos zeroPos = pos.subtract((Vec3i)ship.getPrimaryBlockOffset());
        ArrayList allowedShipMaterials = Lists.newArrayList();
        allowedShipMaterials.add(BlockBehaviour.BlockStateBase::liquid);
        allowedShipMaterials.add(state -> state.is(BlockTags.ICE));
        allowedShipMaterials.add(state -> !state.blocksMotion() && state.getFluidState().is(FluidTags.WATER));
        if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).skyRaiders.get()).booleanValue()) {
            allowedShipMaterials.add(BlockBehaviour.BlockStateBase::isAir);
        }
        if (ShipBasedRaiderUtils.isSurfaceAreaMostlyMaterial(allowedShipMaterials, world, pos.getY(), zeroPos, new BlockPos(zeroPos.getX() + ship.getSizeX() - 1, zeroPos.getY(), zeroPos.getZ() + ship.getSizeZ() - 1), 0.85)) {
            for (int i = 0; i < neededDepth; ++i) {
                if (PathfindingUtils.isLiquid(world.getBlockState(pos.below(i)))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isSurfaceAreaMostlyMaterial(@NotNull List<Predicate<BlockState>> materials, @NotNull Level world, int baseY, @NotNull BlockPos from, @NotNull BlockPos to, double percentRequired) {
        int xDist = Math.abs(from.getX() - to.getX());
        int zDist = Math.abs(from.getZ() - to.getZ());
        int wrongMaterialBlocks = 0;
        int neededMaterialBlocks = (int)(percentRequired * (double)(xDist * zDist));
        int wrongMaterialBlockThreshold = xDist * zDist - neededMaterialBlocks;
        int xDir = 1;
        int zDir = 1;
        if (from.getX() > to.getX()) {
            xDir = -1;
        }
        if (from.getZ() > to.getZ()) {
            zDir = -1;
        }
        for (int x = 0; x < xDist; ++x) {
            for (int z = 0; z < zDist; ++z) {
                BlockState state = world.getBlockState(new BlockPos(from.getX() + x * xDir, baseY, from.getZ() + z * zDir));
                boolean suitableBlock = false;
                for (Predicate<BlockState> pred : materials) {
                    if (!pred.test(state)) continue;
                    suitableBlock = true;
                    break;
                }
                if (suitableBlock) {
                    for (int i = 1; i <= 5; ++i) {
                        if (!world.getBlockState(new BlockPos(from.getX() + x * xDir, baseY + i, from.getZ() + z * zDir)).blocksMotion()) continue;
                        suitableBlock = false;
                        break;
                    }
                }
                if (suitableBlock || ++wrongMaterialBlocks <= wrongMaterialBlockThreshold) continue;
                return false;
            }
        }
        return true;
    }

    public static BlockPos getLoadedPositionTowardsCenter(BlockPos startPos, IColony colony, int maxDistance, BlockPos maxDistancePos, int minDistance, int accuracy) {
        return ShipBasedRaiderUtils.getLoadedPositionTowardsCenter(startPos, colony, maxDistance, maxDistancePos, minDistance, accuracy, false);
    }

    public static BlockPos getLoadedPositionTowardsCenter(BlockPos startPos, IColony colony, int maxDistance, BlockPos maxDistancePos, int minDistance, int accuracy, boolean underWater) {
        if (accuracy < 1) {
            return null;
        }
        if (WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), startPos)) {
            if (underWater) {
                return BlockPosUtil.findAround(colony.getWorld(), startPos, 30, 3, (world, pos) -> (world.getBlockState(pos).isSolid() || world.getBlockState(pos).liquid()) && !world.getBlockState(pos.above()).blocksMotion() && !world.getBlockState(pos.above(2)).blocksMotion());
            }
            return BlockPosUtil.findAround(colony.getWorld(), startPos, 30, 3, (world, pos) -> (world.getBlockState(pos).isSolid() || world.getBlockState(pos).liquid()) && world.getBlockState(pos.above()).isAir() && world.getBlockState(pos.above(2)).isAir());
        }
        BlockPos diff = colony.getCenter().subtract((Vec3i)startPos);
        diff = new BlockPos(diff.getX() / accuracy, diff.getY() / accuracy, diff.getZ() / accuracy);
        int sqMaxDist = maxDistance * maxDistance;
        int sqMinDist = minDistance * minDistance;
        BlockPos tempPos = new BlockPos((Vec3i)startPos);
        for (int i = 0; i < accuracy; ++i) {
            if (BlockPosUtil.getDistanceSquared2D(maxDistancePos, tempPos = tempPos.offset((Vec3i)diff)) > (long)sqMaxDist || BlockPosUtil.getDistanceSquared2D(tempPos, colony.getCenter()) < (long)sqMinDist) {
                return null;
            }
            if (!WorldUtil.isBlockLoaded((LevelAccessor)colony.getWorld(), tempPos)) continue;
            return BlockPosUtil.getFloor(tempPos, colony.getWorld());
        }
        return null;
    }

    public static BlockPos findSpawnPosOnShip(BlockPos spawnPos, Level world, int radius) {
        for (int y = 0; y <= radius * 2; y += 2) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (world.getBlockState(spawnPos.offset(x, y, z)).blocksMotion() || world.getBlockState(spawnPos.offset(x, y + 1, z)).blocksMotion()) continue;
                    return spawnPos.offset(x, y, z);
                }
            }
        }
        return spawnPos;
    }

    public static List<BlockPos> createWaypoints(Level world, Path path, int spacing) {
        ArrayList<BlockPos> wayPoints = new ArrayList<BlockPos>();
        if (path == null) {
            return wayPoints;
        }
        BlockPos lastPoint = BlockPos.ZERO;
        for (int i = 0; i < path.getNodeCount(); ++i) {
            BlockPos point = path.getNode(i).asBlockPos();
            if (lastPoint.distManhattan((Vec3i)point) <= spacing || !world.getBlockState(point).isAir() || !world.getBlockState(point.above()).isAir()) continue;
            wayPoints.add(point);
            lastPoint = point;
        }
        return wayPoints;
    }

    public static BlockPos chooseWaypointFor(List<BlockPos> wayPoints, BlockPos startPos, BlockPos target) {
        BlockPos closest = target;
        BlockPos secondClosest = target;
        for (BlockPos wayPoint : wayPoints) {
            int distToStart = wayPoint.distManhattan((Vec3i)startPos);
            if (distToStart <= 5 || distToStart >= closest.distManhattan((Vec3i)startPos)) continue;
            secondClosest = closest;
            closest = wayPoint;
        }
        if (secondClosest.distManhattan((Vec3i)target) < closest.distManhattan((Vec3i)target)) {
            closest = secondClosest;
        }
        if (closest.distManhattan((Vec3i)target) >= startPos.distManhattan((Vec3i)target)) {
            return target;
        }
        return closest;
    }
}

