/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.guard;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IGuardBuilding;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.statemachine.AIOneTimeEventTarget;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.LookHandler;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.EntityListModule;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIFight;
import com.minecolonies.core.entity.ai.workers.util.MinerLevel;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.other.SittingEntity;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.network.messages.client.SleepingParticleMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEntityAIGuard<J extends AbstractJobGuard<J>, B extends AbstractBuildingGuards>
extends AbstractEntityAIFight<J, B> {
    private static final int ACTIONS_UNTIL_DUMPING = 5;
    private static final int MAX_PATROL_DERIVATION = 80;
    public static final int PATROL_DEVIATION_RAID_POINT = 1600;
    private static final int MAX_FOLLOW_DERIVATION = 30;
    private static final int MAX_GUARD_DERIVATION = 10;
    protected static final int COMBAT_TIME = 600;
    protected LivingEntity target = null;
    private BlockPos currentPatrolPoint = null;
    protected final IGuardBuilding buildingGuards;
    private static final int PARTICLE_INTERVAL = 30;
    private static final int SHOULD_SLEEP_INTERVAL = 200;
    private static final int GUARD_TASK_INTERVAL = 100;
    private static final int GUARD_REGEN_INTERVAL = 40;
    private static final int ACTION_INCREASE_INTERVAL = 10;
    private int sleepTimer = 0;
    protected int wakeTimer = 0;
    protected int fighttimer = 0;
    protected WeakReference<EntityCitizen> sleepingGuard = new WeakReference<Object>(null);
    private Random randomGenerator = new Random();
    private int regularActionTimer = 0;
    private BlockPos lastGuardActionPos;

    public AbstractEntityAIGuard(@NotNull J job) {
        super(job);
        super.registerTargets(new AITarget<CombatAIStates>((CombatAIStates)((Object)AIWorkerState.DECIDE), CombatAIStates.NO_TARGET, 1), new AITarget<Object>(CombatAIStates.NO_TARGET, this::shouldSleep, () -> AIWorkerState.GUARD_SLEEP, 200), new AITarget<Object>(AIWorkerState.GUARD_SLEEP, this::sleep, 1), new AITarget<Object>(AIWorkerState.GUARD_SLEEP, this::sleepParticles, 30), new AITarget<Object>(AIWorkerState.GUARD_REGEN, this::regen, 40), new AITarget<Object>(AIWorkerState.GUARD_FLEE, this::flee, 20), new AITarget<Object>(CombatAIStates.ATTACKING, this::shouldFlee, () -> AIWorkerState.GUARD_FLEE, 40), new AITarget<Object>(CombatAIStates.NO_TARGET, this::shouldFlee, () -> AIWorkerState.GUARD_FLEE, 40), new AITarget<Object>(CombatAIStates.NO_TARGET, this::decide, 100), new AITarget<Object>(AIWorkerState.GUARD_WAKE, this::wakeUpGuard, 20), new AITarget<Object>(CombatAIStates.ATTACKING, this::inCombat, 8));
        this.buildingGuards = (IGuardBuilding)((Object)this.building);
        this.lastGuardActionPos = this.buildingGuards.getPosition();
    }

    private IAIState inCombat() {
        if (this.fighttimer <= 0) {
            this.onCombatEnter();
        }
        if (!this.hasTool()) {
            return AIWorkerState.PREPARING;
        }
        this.fighttimer = 600;
        return null;
    }

    private void onCombatEnter() {
        this.worker.setCanBeStuck(false);
        this.worker.getNavigation().getPathingOptions().setCanUseRails(false);
    }

    private void onCombatLeave() {
        this.worker.getNavigation().getPathingOptions().setCanUseRails(((EntityCitizen)this.worker).canPathOnRails());
        this.worker.setCanBeStuck(true);
    }

    private IAIState wakeUpGuard() {
        if (this.sleepingGuard.get() == null || !(((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob() instanceof AbstractJobGuard) || !((EntityCitizen)this.sleepingGuard.get()).getCitizenJobHandler().getColonyJob(AbstractJobGuard.class).isAsleep()) {
            return CombatAIStates.NO_TARGET;
        }
        ++this.wakeTimer;
        if (this.wakeTimer > 30) {
            return CombatAIStates.NO_TARGET;
        }
        EntityCitizen sleepingCitizen = (EntityCitizen)this.sleepingGuard.get();
        if (!((double)BlockPosUtil.getDistanceSquared(sleepingCitizen.blockPosition(), this.worker.blockPosition()) > 2.25)) {
            this.worker.swing(InteractionHand.OFF_HAND);
            sleepingCitizen.hurt(this.world.damageSources().source(DamageSourceKeys.WAKEY, (Entity)this.worker), 1.0f);
            sleepingCitizen.setLastHurtByMob((LivingEntity)this.worker);
            return CombatAIStates.NO_TARGET;
        }
        this.walkToUnSafePos(sleepingCitizen.blockPosition());
        return this.getState();
    }

    private boolean shouldSleep() {
        if (this.worker.getLastHurtByMob() != null || this.target != null || this.fighttimer > 0) {
            return false;
        }
        double chance = 1.0 / (1.0 + this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SLEEP_LESS));
        if (this.worker.getRandom().nextInt((int)((double)this.worker.getCitizenData().getCitizenSkillHandler().getLevel(Skill.Adaptability) * 0.5) + 20) == 1 && this.worker.getRandom().nextDouble() < chance) {
            this.sleepTimer = this.worker.getRandom().nextInt(500) + 2500;
            this.worker.getNavigation().stop();
            SittingEntity.sitDown(this.worker.blockPosition(), (Mob)this.worker, this.sleepTimer);
            return true;
        }
        return false;
    }

    private IAIState sleepParticles() {
        new SleepingParticleMessage(this.worker.getX(), this.worker.getY() + 2.0, this.worker.getZ()).sendToTrackingEntity((Entity)this.worker);
        if (this.worker.getHealth() < this.worker.getMaxHealth()) {
            this.worker.setHealth(this.worker.getHealth() + 0.5f);
        }
        return null;
    }

    private IAIState sleep() {
        if (this.worker.getLastHurtByMob() != null || (this.sleepTimer -= this.getTickRate()) < 0) {
            this.stopSleeping();
            ((EntityCitizen)this.worker).getThreatTable().removeCurrentTarget();
            this.worker.setLastHurtByMob(null);
            return CombatAIStates.NO_TARGET;
        }
        this.worker.getLookControl().setLookAt(this.worker.getX() + (double)this.worker.getDirection().getStepX(), this.worker.getY() + (double)this.worker.getDirection().getStepY(), this.worker.getZ() + (double)this.worker.getDirection().getStepZ(), 0.0f, 30.0f);
        ((LookHandler)this.worker.getLookControl()).setLookAtCooldown(this.sleepTimer);
        return null;
    }

    private void stopSleeping() {
        if (this.getState() == AIWorkerState.GUARD_SLEEP) {
            this.worker.stopRiding();
            this.worker.setPos(this.worker.getX(), this.worker.getY() + 1.0, this.worker.getZ());
            this.worker.getCitizenExperienceHandler().addExperience(1.0);
            ((LookHandler)this.worker.getLookControl()).setLookAtCooldown(2);
        }
    }

    private boolean shouldFlee() {
        if (this.buildingGuards.shallRetrieveOnLowHealth() && (double)this.worker.getHealth() < (double)((int)this.worker.getMaxHealth()) * 0.2 && this.worker.distanceToSqr(((AbstractBuildingGuards)this.building).getID().getCenter()) > 20.0) {
            return this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.RETREAT) > 0.0;
        }
        return false;
    }

    private IAIState regen() {
        if (((EntityCitizen)this.worker).getThreatTable().getTargetMob() != null && ((EntityCitizen)this.worker).getThreatTable().getTargetMob().distanceTo((Entity)this.worker) < 10.0f) {
            return CombatAIStates.ATTACKING;
        }
        if ((double)this.worker.getHealth() < (double)((int)this.worker.getMaxHealth()) * 0.75 && this.buildingGuards.shallRetrieveOnLowHealth()) {
            if (!this.worker.hasEffect(MobEffects.REGENERATION)) {
                this.worker.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 200));
            }
            return AIWorkerState.GUARD_REGEN;
        }
        return AIWorkerState.START_WORKING;
    }

    private IAIState flee() {
        double effect;
        if (!this.worker.hasEffect(MobEffects.MOVEMENT_SPEED) && (effect = this.worker.getCitizenColonyHandler().getColonyOrRegister().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.FLEEING_SPEED)) > 0.0) {
            this.worker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 200, (int)(0.0 + effect)));
        }
        if (!this.walkToBuilding()) {
            return AIWorkerState.GUARD_FLEE;
        }
        return AIWorkerState.GUARD_REGEN;
    }

    private IAIState guard() {
        this.guardMovement();
        return this.getState();
    }

    public void guardMovement() {
        this.walkToSafePos(this.buildingGuards.getGuardPos());
    }

    private IAIState follow() {
        if (BlockPosUtil.getDistance2D(this.worker.blockPosition(), this.buildingGuards.getPositionToFollow()) > 30L) {
            TeleportHelper.teleportCitizen(this.worker, this.worker.getCommandSenderWorld(), this.buildingGuards.getPositionToFollow());
            return null;
        }
        this.walkToUnSafePos(this.buildingGuards.getPositionToFollow(), this.buildingGuards.isTightGrouping() ? 6 : 15);
        return null;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 5 * ((AbstractBuildingGuards)this.building).getBuildingLevel();
    }

    private IAIState rally(ILocation location) {
        ICitizenData citizenData = this.worker.getCitizenData();
        if (!this.walkToUnSafePos(location.getInDimensionLocation().offset(this.randomGenerator.nextInt(6) - 3, 0, this.randomGenerator.nextInt(6) - 3), 6) && citizenData != null && !this.worker.hasEffect(MobEffects.MOVEMENT_SPEED)) {
            this.worker.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 100, Mth.clamp((int)(citizenData.getCitizenSkillHandler().getLevel(Skill.Adaptability) / 20), (int)2, (int)5), false, false));
        }
        return null;
    }

    @Override
    protected IAIState startWorkingAtOwnBuilding() {
        if (this.buildingGuards != null) {
            this.buildingGuards.setTempNextPatrolPoint(this.buildingGuards.getPosition());
        }
        return AIWorkerState.DECIDE;
    }

    public IAIState patrol() {
        if (this.buildingGuards.requiresManualTarget()) {
            if (this.currentPatrolPoint == null || this.walkToSafePos(this.currentPatrolPoint)) {
                this.currentPatrolPoint = null;
                if (!EntityNavigationUtils.walkToRandomPos(this.worker, 20, 1.0)) {
                    return this.getState();
                }
                if (this.worker.getRandom().nextInt(5) <= 1) {
                    this.currentPatrolPoint = this.buildingGuards.getColony().getBuildingManager().getRandomBuilding(b -> true);
                    if (this.currentPatrolPoint != null) {
                        this.walkToSafePos(this.currentPatrolPoint);
                    }
                }
            }
        } else {
            if (this.currentPatrolPoint == null) {
                this.currentPatrolPoint = this.buildingGuards.getNextPatrolTarget(false);
            }
            if (this.currentPatrolPoint != null && this.walkToSafePos(this.currentPatrolPoint)) {
                this.buildingGuards.arrivedAtPatrolPoint(this.worker);
            }
        }
        return null;
    }

    public IAIState patrolMine() {
        if (this.buildingGuards.getMinePos() == null) {
            return AIWorkerState.PREPARING;
        }
        if (this.currentPatrolPoint == null || this.walkToSafePos(this.currentPatrolPoint)) {
            IBuilding building = this.buildingGuards.getColony().getBuildingManager().getBuilding(this.buildingGuards.getMinePos());
            if (building != null) {
                if (building instanceof BuildingMiner) {
                    BuildingMiner buildingMiner = (BuildingMiner)building;
                    MinerLevel level = buildingMiner.getModule(BuildingModules.MINER_LEVELS).getCurrentLevel();
                    if (level == null) {
                        this.setNextPatrolTarget(buildingMiner.getPosition());
                    } else {
                        this.setNextPatrolTarget(level.getRandomCompletedNode(buildingMiner));
                    }
                } else {
                    ((SettingsModule)this.buildingGuards.getModule(BuildingModules.GUARD_SETTINGS)).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
                }
            } else {
                ((SettingsModule)this.buildingGuards.getModule(BuildingModules.GUARD_SETTINGS)).getSetting(AbstractBuildingGuards.GUARD_TASK).set("com.minecolonies.core.guard.setting.patrol");
            }
        }
        return null;
    }

    public void setNextPatrolTargetAndMove(BlockPos target) {
        this.setNextPatrolTarget(target);
        this.registerTarget(new AIOneTimeEventTarget<Supplier<Object>>(() -> {
            if (this.getState() == CombatAIStates.NO_TARGET) {
                return this.decide();
            }
            return this.getState();
        }));
    }

    private void setNextPatrolTarget(BlockPos target) {
        this.currentPatrolPoint = target;
    }

    public BlockPos getCurrentPatrolPoint() {
        return this.currentPatrolPoint;
    }

    public boolean hasTool() {
        for (EquipmentTypeEntry toolType : this.toolsNeeded) {
            if (InventoryUtils.hasItemHandlerEquipmentWithLevel((IItemHandler)this.getInventory(), toolType, 0, this.buildingGuards.getMaxEquipmentLevel())) continue;
            return false;
        }
        return true;
    }

    public void startHelpCitizen(LivingEntity attacker) {
        if (this.canHelp(attacker.blockPosition())) {
            ((IThreatTableEntity)((Object)this.worker)).getThreatTable().addThreat(attacker, 20);
            this.registerTarget(new AIOneTimeEventTarget<IAIState>(CombatAIStates.ATTACKING));
        }
    }

    public boolean canHelp(BlockPos pos) {
        if ((this.getState() == CombatAIStates.NO_TARGET || this.getState() == AIWorkerState.GUARD_SLEEP) && this.canBeInterrupted()) {
            if (this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.guard") && !this.isWithinPersecutionDistance(pos, this.getPersecutionDistance())) {
                return false;
            }
            this.stopSleeping();
            return true;
        }
        return false;
    }

    protected IAIState decide() {
        ILocation rallyLocation = this.buildingGuards.getRallyLocation();
        if (this.regularActionTimer++ > 10) {
            this.incrementActionsDone();
            this.regularActionTimer = 0;
        }
        if (this.worker.getRandom().nextDouble() < 0.05) {
            this.equipInventoryArmor();
        }
        if (!this.hasTool()) {
            return AIWorkerState.PREPARING;
        }
        if (this.fighttimer > 0) {
            this.fighttimer -= 100;
            if (this.fighttimer <= 0) {
                this.onCombatLeave();
            }
        } else {
            this.worker.stopUsingItem();
            this.lastGuardActionPos = this.worker.blockPosition();
        }
        if (rallyLocation != null || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.follow")) {
            this.worker.addEffect(new MobEffectInstance(MobEffects.GLOWING, 600, 20, false, false));
        } else {
            this.worker.removeEffect(MobEffects.GLOWING);
        }
        if (rallyLocation != null && rallyLocation.isReachableFromLocation(this.worker.getLocation())) {
            return this.rally(rallyLocation);
        }
        return switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol" -> this.patrol();
            case "com.minecolonies.core.guard.setting.guard" -> this.guard();
            case "com.minecolonies.core.guard.setting.follow" -> this.follow();
            case "com.minecolonies.core.guard.setting.patrol_mine" -> this.patrolMine();
            default -> AIWorkerState.PREPARING;
        };
    }

    public boolean isWithinPersecutionDistance(BlockPos entityPos, double attackRange) {
        return (double)BlockPosUtil.getDistanceSquared(this.getTaskReferencePoint(), entityPos) <= Math.pow((double)this.getPersecutionDistance() + attackRange, 2.0);
    }

    private BlockPos getTaskReferencePoint() {
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": 
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return this.lastGuardActionPos;
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return this.buildingGuards.getPositionToFollow();
            }
        }
        return this.buildingGuards.getGuardPos();
    }

    private int getPersecutionDistance() {
        if (this.buildingGuards.getRallyLocation() != null) {
            return 30;
        }
        switch (this.buildingGuards.getTask()) {
            case "com.minecolonies.core.guard.setting.patrol": 
            case "com.minecolonies.core.guard.setting.patrol_mine": {
                return 80;
            }
            case "com.minecolonies.core.guard.setting.follow": {
                return 30;
            }
        }
        return 10 + (this.getModuleForJob().getJobEntry() == ModJobs.knight.get() ? 20 : 0);
    }

    @Override
    public boolean canBeInterrupted() {
        if (this.fighttimer > 0 || this.getState() == CombatAIStates.ATTACKING || this.worker.getLastAttacker() != null || this.buildingGuards.getRallyLocation() != null || this.buildingGuards.getTask().equals("com.minecolonies.core.guard.setting.follow")) {
            return false;
        }
        return super.canBeInterrupted();
    }

    public void setWakeCitizen(EntityCitizen citizen) {
        this.sleepingGuard = new WeakReference<EntityCitizen>(citizen);
        this.wakeTimer = 0;
        this.registerTarget(new AIOneTimeEventTarget<IAIState>(AIWorkerState.GUARD_WAKE));
    }

    @Override
    public Class<B> getExpectedBuildingClass() {
        return AbstractBuildingGuards.class;
    }

    public static boolean isAttackableTarget(AbstractEntityCitizen user, LivingEntity entity) {
        EntityCitizen otherCitizen;
        if (IColonyManager.getInstance().getCompatibilityManager().getAllMonsters().contains((Object)BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType())) && !((EntityListModule)user.getCitizenData().getWorkBuilding().getModuleMatching(EntityListModule.class, m -> m.getId().equals("hostiles"))).isEntityInList(BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType()))) {
            return true;
        }
        IColony colony = user.getCitizenColonyHandler().getColonyOrRegister();
        if (colony == null) {
            return false;
        }
        if (entity instanceof Player && (colony.getPermissions().hasPermission((Player)entity, Action.GUARDS_ATTACK) || colony.isValidAttackingPlayer((Player)entity))) {
            return true;
        }
        return entity instanceof EntityCitizen && (otherCitizen = (EntityCitizen)entity).getCitizenColonyHandler().getColonyId() != colony.getID() && colony.isValidAttackingGuard((AbstractEntityCitizen)entity);
    }
}

