/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.service;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.entity.ai.statemachine.AITarget;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.ai.statemachine.states.IAIState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.EnchanterStationsModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingEnchanter;
import com.minecolonies.core.colony.interactionhandling.StandardInteraction;
import com.minecolonies.core.colony.jobs.JobEnchanter;
import com.minecolonies.core.entity.ai.workers.crafting.AbstractEntityAICrafting;
import com.minecolonies.core.network.messages.client.CircleParticleEffectMessage;
import com.minecolonies.core.network.messages.client.StreamParticleEffectMessage;
import com.minecolonies.core.util.WorkerUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkEnchanter
extends AbstractEntityAICrafting<JobEnchanter, BuildingEnchanter> {
    private static final Predicate<ItemStack> IS_ANCIENT_TOME = item -> !item.isEmpty() && item.getItem() == ModItems.ancientTome;
    private static final Predicate<ItemStack> IS_BOOK = item -> !item.isEmpty() && item.getItem() == Items.BOOK;
    private static final long MIN_DISTANCE_TO_DRAIN = 10L;
    private static final int MAX_PROGRESS_TICKS = 60;
    private static final int MAX_ENCHANTMENT_TICKS = 300;
    private static final int MANA_REQ_PER_LEVEL = 10;
    private static final double XP_PER_DRAIN = 10.0;
    private ICitizenData citizenToGatherFrom = null;
    private int progressTicks = 0;

    public EntityAIWorkEnchanter(@NotNull JobEnchanter job) {
        super(job);
        super.registerTargets(new AITarget<Object>(AIWorkerState.ENCHANTER_DRAIN, this::gatherAndDrain, 10), new AITarget<Object>(AIWorkerState.ENCHANT, this::enchant, 20));
        this.worker.setCanPickUpLoot(true);
    }

    @Override
    protected IAIState decide() {
        int ancientTomesInInv;
        this.worker.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        if (!this.walkToBuilding()) {
            return AIWorkerState.START_WORKING;
        }
        IAIState craftState = this.getNextCraftingState();
        if (craftState != AIWorkerState.START_WORKING && !WorldUtil.isPastTime((Level)this.world, 6000)) {
            return craftState;
        }
        if (this.wantInventoryDumped()) {
            return this.getState();
        }
        if (this.getPrimarySkillLevel() < ((BuildingEnchanter)this.building).getBuildingLevel() * 10) {
            BuildingEnchanter enchanterBuilding = (BuildingEnchanter)this.building;
            EnchanterStationsModule module = enchanterBuilding.getModule(BuildingModules.ENCHANTER_STATIONS);
            if (module.getBuildingsToGatherFrom().isEmpty()) {
                if (this.worker.getCitizenData() != null) {
                    this.worker.getCitizenData().triggerInteraction(new StandardInteraction((Component)Component.translatableEscape((String)"com.minecolonies.coremod.enchanter.nodrainingsset", (Object[])new Object[0]), ChatPriority.BLOCKING));
                }
                return AIWorkerState.IDLE;
            }
            int booksInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_BOOK);
            if (booksInInv <= 0) {
                int numberOfBooksInBuilding = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, IS_BOOK, 1);
                if (numberOfBooksInBuilding > 0) {
                    this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(IS_BOOK, 1);
                    return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
                }
                this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)Items.BOOK, 1));
                return AIWorkerState.IDLE;
            }
            BlockPos posToDrainFrom = module.getRandomBuildingToDrainFrom();
            if (posToDrainFrom == null) {
                return AIWorkerState.IDLE;
            }
            ((JobEnchanter)this.job).setBuildingToDrainFrom(posToDrainFrom);
            return AIWorkerState.ENCHANTER_DRAIN;
        }
        @NotNull BuildingEnchanter.CraftingModule craftingModule = (BuildingEnchanter.CraftingModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(BuildingEnchanter.CraftingModule.class);
        boolean ancientTomeCraftingDisabled = false;
        for (IToken<?> token : craftingModule.getRecipes()) {
            IRecipeStorage storage = (IRecipeStorage)IColonyManager.getInstance().getRecipeManager().getRecipes().get(token);
            if (storage == null || storage.getInput().isEmpty() || storage.getInput().get(0).getItem() != ModItems.ancientTome || !craftingModule.isDisabled(token)) continue;
            ancientTomeCraftingDisabled = true;
        }
        if (!ancientTomeCraftingDisabled && (ancientTomesInInv = InventoryUtils.getItemCountInItemHandler((IItemHandler)this.worker.getInventoryCitizen(), IS_ANCIENT_TOME)) <= 0) {
            int amountOfAncientTomes = InventoryUtils.hasBuildingEnoughElseCount((IBuilding)this.building, IS_ANCIENT_TOME, 1);
            if (amountOfAncientTomes > 0) {
                this.needsCurrently = new Tuple<Predicate<ItemStack>, Integer>(IS_ANCIENT_TOME, 1);
                return AIWorkerState.GATHERING_REQUIRED_MATERIALS;
            }
            this.checkIfRequestForItemExistOrCreateAsync(new ItemStack((ItemLike)ModItems.ancientTome, 1), 1, 1, false);
            return AIWorkerState.IDLE;
        }
        return AIWorkerState.ENCHANT;
    }

    @Override
    protected int getActionsDoneUntilDumping() {
        return 1;
    }

    private IAIState enchant() {
        List<ItemStack> loot;
        this.currentRecipeStorage = ((BuildingEnchanter.CraftingModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(BuildingEnchanter.CraftingModule.class)).getFirstFulfillableRecipe(ItemStackUtils::isEmpty, 1, false);
        if (this.currentRecipeStorage == null) {
            this.progressTicks = 0;
            return AIWorkerState.START_WORKING;
        }
        if (this.progressTicks++ < 300 / ((BuildingEnchanter)this.building).getBuildingLevel()) {
            new CircleParticleEffectMessage(this.worker.position().add(0.0, 2.0, 0.0), ParticleTypes.ENCHANT, this.progressTicks).sendToTrackingEntity((Entity)this.worker);
            new CircleParticleEffectMessage(this.worker.position().add(0.0, 1.5, 0.0), ParticleTypes.ENCHANT, this.progressTicks).sendToTrackingEntity((Entity)this.worker);
            new CircleParticleEffectMessage(this.worker.position().add(0.0, 1.0, 0.0), ParticleTypes.ENCHANT, this.progressTicks).sendToTrackingEntity((Entity)this.worker);
            this.worker.queueSound(SoundEvents.ENCHANTMENT_TABLE_USE, this.worker.blockPosition().above(), 20, 0, 0.5f, this.worker.getRandom().nextFloat());
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.swing(InteractionHand.MAIN_HAND);
            } else {
                this.worker.swing(InteractionHand.OFF_HAND);
            }
            return this.getState();
        }
        ICitizenData data = this.worker.getCitizenData();
        if (data != null && (loot = this.currentRecipeStorage.fullfillRecipeAndCopy(this.getLootContext(), ((BuildingEnchanter)this.building).getHandlers(), true)) != null) {
            int enchantmentLevel = loot.stream().mapToInt(EntityAIWorkEnchanter::getEnchantedBookLevel).max().orElse(0);
            data.getCitizenSkillHandler().incrementLevel(Skill.Mana, -enchantmentLevel);
            this.incrementActionsDoneAndDecSaturation();
        }
        this.currentRecipeStorage = null;
        this.progressTicks = 0;
        return AIWorkerState.IDLE;
    }

    private static int getEnchantedBookLevel(@NotNull ItemStack stack) {
        if (stack.getItem().equals(Items.ENCHANTED_BOOK)) {
            int level = 0;
            for (Object2IntMap.Entry entry : ((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)).entrySet()) {
                level = Math.max(level, entry.getIntValue());
            }
            return level;
        }
        return 0;
    }

    private IAIState gatherAndDrain() {
        if (((JobEnchanter)this.job).getPosToDrainFrom() == null) {
            return AIWorkerState.IDLE;
        }
        IBuilding buildingWorker = ((BuildingEnchanter)this.building).getColony().getBuildingManager().getBuilding(((JobEnchanter)this.job).getPosToDrainFrom());
        if (!this.walkToBuilding(buildingWorker)) {
            return this.getState();
        }
        if (buildingWorker == null) {
            this.resetDraining();
            ((EnchanterStationsModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(EnchanterStationsModule.class)).removeWorker(((JobEnchanter)this.job).getPosToDrainFrom());
            return AIWorkerState.IDLE;
        }
        if (this.citizenToGatherFrom == null) {
            AbstractEntityCitizen citizen;
            ArrayList workers = new ArrayList();
            for (Optional<AbstractEntityCitizen> citizen2 : this.getModuleForJob().getAssignedEntities()) {
                citizen2.ifPresent(workers::add);
            }
            if (workers.size() > 1) {
                citizen = (AbstractEntityCitizen)workers.get(this.worker.getRandom().nextInt(workers.size()));
            } else {
                if (workers.isEmpty()) {
                    this.resetDraining();
                    return AIWorkerState.START_WORKING;
                }
                citizen = (AbstractEntityCitizen)workers.get(0);
            }
            this.citizenToGatherFrom = citizen.getCitizenData();
            this.progressTicks = 0;
            return this.getState();
        }
        if (!this.citizenToGatherFrom.getEntity().isPresent()) {
            this.citizenToGatherFrom = null;
            return this.getState();
        }
        if (this.progressTicks == 0 && BlockPosUtil.getDistance2D(this.citizenToGatherFrom.getEntity().get().blockPosition(), this.worker.blockPosition()) > 10L) {
            if (!((JobEnchanter)this.job).incrementWaitingTicks()) {
                this.resetDraining();
                return AIWorkerState.START_WORKING;
            }
            return this.getState();
        }
        ++this.progressTicks;
        if (this.progressTicks < 60) {
            Vec3 start = this.worker.position().add(0.0, 2.0, 0.0);
            Vec3 goal = this.citizenToGatherFrom.getEntity().get().position().add(0.0, 2.0, 0.0);
            new StreamParticleEffectMessage(start, goal, ParticleTypes.ENCHANT, this.progressTicks % 60, 60).sendToTrackingEntity((Entity)this.worker);
            new CircleParticleEffectMessage(start, ParticleTypes.HAPPY_VILLAGER, this.progressTicks).sendToTrackingEntity((Entity)this.worker);
            WorkerUtil.faceBlock(BlockPos.containing((Position)goal), this.worker);
            if (this.worker.getRandom().nextBoolean()) {
                this.worker.swing(InteractionHand.MAIN_HAND);
            } else {
                this.worker.swing(InteractionHand.OFF_HAND);
            }
            return this.getState();
        }
        int bookSlot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.worker.getInventoryCitizen(), Items.BOOK);
        if (bookSlot != -1) {
            int size = this.citizenToGatherFrom.getInventory().getSlots();
            int attempts = (int)((double)this.getSecondarySkillLevel() / 5.0);
            for (int i = 0; i < attempts; ++i) {
                int randomSlot = this.worker.getRandom().nextInt(size);
                ItemStack stack = this.citizenToGatherFrom.getInventory().getStackInSlot(randomSlot);
                if (stack.isEmpty() || !stack.isEnchantable()) continue;
                EnchantmentHelper.enchantItem((RandomSource)this.worker.getRandom(), (ItemStack)stack, (int)(this.getSecondarySkillLevel() > 50 ? 2 : 1), (RegistryAccess)this.world.registryAccess(), Optional.empty());
                break;
            }
            this.worker.getInventoryCitizen().extractItem(bookSlot, 1, false);
            this.worker.getCitizenData().getCitizenSkillHandler().incrementLevel(Skill.Mana, 1);
            this.worker.getCitizenExperienceHandler().addExperience(10.0);
            this.worker.getCitizenData().markDirty(80);
        }
        this.resetDraining();
        return AIWorkerState.IDLE;
    }

    private void resetDraining() {
        ((EnchanterStationsModule)((BuildingEnchanter)this.building).getFirstModuleOccurance(EnchanterStationsModule.class)).setAsGathered(((JobEnchanter)this.job).getPosToDrainFrom());
        this.citizenToGatherFrom = null;
        ((JobEnchanter)this.job).setBuildingToDrainFrom(null);
        this.progressTicks = 0;
        this.incrementActionsDoneAndDecSaturation();
    }

    @Override
    public Class<BuildingEnchanter> getExpectedBuildingClass() {
        return BuildingEnchanter.class;
    }
}

