/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.minecolonies.api.entity.ai.IStateAI;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMonster;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.entity.mobs.IArcherMobEntity;
import com.minecolonies.api.entity.mobs.IRangedMobEntity;
import com.minecolonies.api.entity.mobs.drownedpirate.AbstractDrownedEntityPirateRaider;
import com.minecolonies.api.entity.mobs.registry.IMobAIRegistry;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.core.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.mobs.aitasks.CampWalkAI;
import com.minecolonies.core.entity.mobs.aitasks.EntityAIBreakDoor;
import com.minecolonies.core.entity.mobs.aitasks.RaiderMeleeAI;
import com.minecolonies.core.entity.mobs.aitasks.RaiderRangedAI;
import com.minecolonies.core.entity.mobs.aitasks.RaiderWalkAI;
import com.minecolonies.core.util.MultimapCollector;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class MobAIRegistry
implements IMobAIRegistry {
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMonster, Goal>> mobAiTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMonster, Goal>> mobAiTargetTasks = Lists.newArrayList();
    private final List<TaskInformationWrapper<AbstractEntityMinecoloniesMonster, IStateAI>> mobStateAITasks = Lists.newArrayList();

    public MobAIRegistry() {
        MobAIRegistry.setupMobAiTasks(this);
    }

    private static void setupMobAiTasks(IMobAIRegistry registry) {
        registry.registerNewAiTaskForMobs(0, FloatGoal::new, mob -> !(mob instanceof AbstractDrownedEntityPirateRaider)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIInteractToggleAble((AbstractFastMinecoloniesEntity)mob, EntityAIInteractToggleAble.FENCE_TOGGLE)).registerNewAiTargetTaskForMobs(3, mob -> new EntityAIBreakDoor((Mob)mob)).registerNewAiTaskForMobs(5, mob -> new LookAtPlayerGoal((Mob)mob, Player.class, 8.0f)).registerNewAiTaskForMobs(6, mob -> new LookAtPlayerGoal((Mob)mob, EntityCitizen.class, 8.0f)).registerNewStateAI(mob -> new RaiderMeleeAI<AbstractEntityMinecoloniesMonster>((AbstractEntityMinecoloniesMonster)mob, mob.getAI()), mob -> !(mob instanceof IArcherMobEntity)).registerNewStateAI(mob -> new RaiderRangedAI<AbstractEntityMinecoloniesMonster>((AbstractEntityMinecoloniesMonster)mob, mob.getAI()), mob -> mob instanceof IRangedMobEntity).registerNewStateAI(mob -> new RaiderWalkAI((AbstractEntityMinecoloniesRaider)mob, mob.getAI()), mob -> mob instanceof AbstractEntityMinecoloniesRaider).registerNewStateAI(mob -> new CampWalkAI((AbstractEntityMinecoloniesMonster)mob, mob.getAI()), mob -> !(mob instanceof AbstractEntityMinecoloniesRaider));
    }

    @Override
    @NotNull
    public Multimap<Integer, Goal> getEntityAiTasksForMobs(AbstractEntityMinecoloniesMonster mob) {
        return (Multimap)this.mobAiTasks.stream().filter(wrapper -> wrapper.entityPredicate.test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> (Goal)wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTaskForMobs(int priority, Function<AbstractEntityMinecoloniesMonster, Goal> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMonster> applyPredicate) {
        this.mobAiTasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMonster, Goal>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewStateAI(Function<AbstractEntityMinecoloniesMonster, IStateAI> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMonster> applyPredicate) {
        this.mobStateAITasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMonster, IStateAI>(0, aiTaskProducer, applyPredicate));
        return this;
    }

    @Override
    @NotNull
    public void applyToMob(AbstractEntityMinecoloniesMonster mob) {
        for (TaskInformationWrapper<AbstractEntityMinecoloniesMonster, IStateAI> taskInformationWrapper : this.mobStateAITasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            taskInformationWrapper.aiTaskProducer.apply(mob);
        }
        for (TaskInformationWrapper<AbstractEntityMinecoloniesMonster, IStateAI> taskInformationWrapper : this.mobAiTargetTasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            mob.goalSelector.addGoal(taskInformationWrapper.priority, (Goal)taskInformationWrapper.aiTaskProducer.apply(mob));
        }
        for (TaskInformationWrapper<AbstractEntityMinecoloniesMonster, IStateAI> taskInformationWrapper : this.mobAiTasks) {
            if (!taskInformationWrapper.entityPredicate.test(mob)) continue;
            mob.goalSelector.addGoal(taskInformationWrapper.priority, (Goal)taskInformationWrapper.aiTaskProducer.apply(mob));
        }
    }

    @Override
    @NotNull
    public Multimap<Integer, Goal> getEntityAiTargetTasksForMobs(AbstractEntityMinecoloniesMonster mob) {
        return (Multimap)this.mobAiTargetTasks.stream().filter(wrapper -> wrapper.getEntityPredicate().test(mob)).collect(MultimapCollector.toMultimap(TaskInformationWrapper::getPriority, wrapper -> (Goal)wrapper.getAiTaskProducer().apply(mob)));
    }

    @Override
    @NotNull
    public IMobAIRegistry registerNewAiTargetTaskForMobs(int priority, Function<AbstractEntityMinecoloniesMonster, Goal> aiTaskProducer, Predicate<AbstractEntityMinecoloniesMonster> applyPredicate) {
        this.mobAiTargetTasks.add(new TaskInformationWrapper<AbstractEntityMinecoloniesMonster, Goal>(priority, aiTaskProducer, applyPredicate));
        return this;
    }

    private static final class TaskInformationWrapper<M extends Entity, G> {
        private final int priority;
        private final Function<AbstractEntityMinecoloniesMonster, G> aiTaskProducer;
        private final Predicate<M> entityPredicate;

        TaskInformationWrapper(int priority, Function<AbstractEntityMinecoloniesMonster, G> aiTaskProducer, Predicate<M> entityPredicate) {
            this.priority = priority;
            this.aiTaskProducer = aiTaskProducer;
            this.entityPredicate = entityPredicate;
        }

        public int getPriority() {
            return this.priority;
        }

        public Function<AbstractEntityMinecoloniesMonster, G> getAiTaskProducer() {
            return this.aiTaskProducer;
        }

        public Predicate<M> getEntityPredicate() {
            return this.entityPredicate;
        }
    }
}

