/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding;

import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.minecolonies.api.blocks.huts.AbstractBlockMinecoloniesDefault;
import com.minecolonies.api.entity.mobs.drownedpirate.AbstractDrownedEntityPirateRaider;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.core.entity.pathfinding.PathPointExtended;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.world.CachingBlockLookup;
import com.minecolonies.core.network.messages.client.SyncPathReachedMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathfindingUtils {
    private static Object empty = Fluids.EMPTY.defaultFluidState();
    public static final Map<UUID, UUID> trackingMap = new ConcurrentHashMap<UUID, UUID>();
    public static final Map<String, UUID> trackByType = new HashMap<String, UUID>();

    public static void syncDebugReachedPositions(HashSet<BlockPos> reached, List<ServerPlayer> players) {
        if (reached.isEmpty() || players.isEmpty()) {
            return;
        }
        SyncPathReachedMessage message = new SyncPathReachedMessage(reached);
        for (ServerPlayer player : players) {
            message.sendToPlayer(player);
        }
    }

    public static BlockPos prepareStart(@NotNull LivingEntity entity) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(Mth.floor((double)entity.getX()), Mth.floor((double)entity.getY()), Mth.floor((double)entity.getZ()));
        Level level = entity.level();
        BlockState bs = level.getBlockState((BlockPos)pos);
        BlockPos.MutableBlockPos below = new BlockPos.MutableBlockPos(pos.getX(), pos.getY() - 1, pos.getZ());
        if (entity.onGround() && SurfaceType.getSurfaceType((BlockGetter)level, level.getBlockState((BlockPos)below), (BlockPos)below) != SurfaceType.WALKABLE) {
            int minX = Mth.floor((double)entity.getBoundingBox().minX);
            int minZ = Mth.floor((double)entity.getBoundingBox().minZ);
            int maxX = Mth.floor((double)entity.getBoundingBox().maxX);
            int maxZ = Mth.floor((double)entity.getBoundingBox().maxZ);
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos toCheck = new BlockPos(x, below.getY(), z);
                    if (x == pos.getX() && z == pos.getZ() || SurfaceType.getSurfaceType((BlockGetter)level, level.getBlockState(toCheck), toCheck) != SurfaceType.WALKABLE || !(Math.abs(ShapeUtil.max(level.getBlockState(toCheck).getCollisionShape((BlockGetter)level, toCheck), Direction.Axis.Y) + (double)toCheck.getY() - entity.getY()) < 0.1)) continue;
                    pos.setX(x);
                    pos.setZ(z);
                    below.setX(x);
                    below.setZ(z);
                }
            }
        }
        VoxelShape collisionShape = bs.getCollisionShape((BlockGetter)level, (BlockPos)pos);
        boolean isFineToStandIn = PathfindingUtils.canStandInSolidBlock(bs);
        if (bs.blocksMotion() && !isFineToStandIn && collisionShape.max(Direction.Axis.Y) > 0.0) {
            double relPosX = Math.abs(entity.getX() % 1.0);
            double relPosZ = Math.abs(entity.getZ() % 1.0);
            for (AABB box : collisionShape.toAabbs()) {
                if (!(relPosX >= box.minX) || !(relPosX <= box.maxX) || !(relPosZ >= box.minZ) || !(relPosZ <= box.maxZ) || !(box.maxY > 0.0)) continue;
                pos.set(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = level.getBlockState((BlockPos)pos);
                break;
            }
        }
        BlockState down = level.getBlockState(pos.below());
        while (PathfindingUtils.canStandInSolidBlock(bs) && PathfindingUtils.canStandInSolidBlock(down) && !down.getBlock().isLadder(down, (LevelReader)level, pos.below(), entity) && down.getFluidState().isEmpty()) {
            pos.move(Direction.DOWN, 1);
            bs = down;
            down = level.getBlockState(pos.below());
            if (pos.getY() >= entity.getCommandSenderWorld().getMinBuildHeight()) continue;
            return entity.blockPosition();
        }
        Block b = bs.getBlock();
        if (entity.isInWater() && !(entity instanceof AbstractDrownedEntityPirateRaider)) {
            while (!bs.getFluidState().isEmpty()) {
                pos.set(pos.getX(), pos.getY() + 1, pos.getZ());
                bs = level.getBlockState((BlockPos)pos);
            }
        } else if (b instanceof FenceBlock || b instanceof WallBlock || b instanceof AbstractBlockMinecoloniesDefault || bs.blocksMotion() && !PathfindingUtils.canStandInSolidBlock(bs)) {
            VoxelShape shape = bs.getCollisionShape((BlockGetter)level, (BlockPos)pos);
            if (shape.isEmpty()) {
                return pos.immutable();
            }
            Vec3 relativePos = entity.position().subtract(shape.move((double)entity.getBlockX(), (double)entity.getBlockY(), (double)entity.getBlockZ()).bounds().getCenter());
            double dX = relativePos.x;
            double dZ = relativePos.z;
            if (Math.abs(dX) < Math.abs(dZ)) {
                pos.set(pos.getX(), pos.getY(), dZ < 0.0 ? pos.getZ() - 1 : pos.getZ() + 1);
            } else {
                pos.set(dX < 0.0 ? pos.getX() - 1 : pos.getX() + 1, pos.getY(), pos.getZ());
            }
        }
        return pos.immutable();
    }

    private static boolean canStandInSolidBlock(BlockState state) {
        return state.getBlock() instanceof DoorBlock || state.getBlock() instanceof TrapDoorBlock || state.getBlock() instanceof PanelBlock && (Boolean)state.getValue((Property)PanelBlock.OPEN) != false || !state.getBlock().hasCollision;
    }

    public static void setLadderFacing(@NotNull LevelReader world, BlockPos pos, @NotNull PathPointExtended p) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof VineBlock) {
            if (((Boolean)state.getValue((Property)VineBlock.SOUTH)).booleanValue()) {
                p.setLadderFacing(Direction.NORTH);
            } else if (((Boolean)state.getValue((Property)VineBlock.WEST)).booleanValue()) {
                p.setLadderFacing(Direction.EAST);
            } else if (((Boolean)state.getValue((Property)VineBlock.NORTH)).booleanValue()) {
                p.setLadderFacing(Direction.SOUTH);
            } else if (((Boolean)state.getValue((Property)VineBlock.EAST)).booleanValue()) {
                p.setLadderFacing(Direction.WEST);
            }
        } else if (block instanceof LadderBlock) {
            p.setLadderFacing((Direction)state.getValue((Property)LadderBlock.FACING));
        } else {
            p.setLadderFacing(Direction.UP);
        }
    }

    public static boolean isLiquid(BlockState state) {
        return state.liquid() || !state.blocksMotion() && !state.getFluidState().isEmpty();
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos) {
        return PathfindingUtils.isWater(world, pos, null, null);
    }

    public static boolean isWater(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.getBlockState(pos);
        }
        if (state.isSolid()) {
            return false;
        }
        if (state.getBlock() == Blocks.WATER) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = state.getFluidState();
        }
        if (fluidState == empty || fluidState.isEmpty()) {
            return false;
        }
        if (state.getBlock() instanceof TrapdoorBlock || state.getBlock() instanceof PanelBlock && !((Boolean)state.getValue((Property)TrapdoorBlock.OPEN)).booleanValue() && state.getValue((Property)TrapdoorBlock.HALF) == Half.TOP) {
            return false;
        }
        Fluid fluid = fluidState.getType();
        return fluid == Fluids.WATER || fluid == Fluids.FLOWING_WATER;
    }

    public static boolean isLava(@NotNull BlockGetter world, BlockPos pos, @Nullable BlockState pState, @Nullable FluidState pFluidState) {
        BlockState state = pState;
        if (state == null) {
            state = world.getBlockState(pos);
        }
        if (state.getBlock() == Blocks.LAVA) {
            return true;
        }
        FluidState fluidState = pFluidState;
        if (fluidState == null) {
            fluidState = world.getFluidState(pos);
        }
        if (fluidState == empty || fluidState.isEmpty()) {
            return false;
        }
        Fluid fluid = fluidState.getType();
        return fluid == Fluids.LAVA || fluid == Fluids.FLOWING_LAVA;
    }

    public static boolean isLadder(BlockState blockState, @Nullable PathingOptions options) {
        if (options != null && options.canWalkUnderWater() && PathfindingUtils.isLiquid(blockState)) {
            return true;
        }
        return blockState.is(BlockTags.CLIMBABLE) && (options != null && options.canClimbAdvanced() || blockState.getBlock() instanceof LadderBlock || blockState.is(ModTags.freeClimbBlocks));
    }

    public static boolean isDangerous(BlockState blockState) {
        Block block = blockState.getBlock();
        return blockState.is(ModTags.dangerousBlocks) || block instanceof FireBlock || block instanceof CampfireBlock || block instanceof MagmaBlock || block instanceof SweetBerryBushBlock || block instanceof PowderSnowBlock;
    }

    public static boolean hasAnyCollisionAlong(int startX, int startY, int startZ, int endX, int endY, int endZ, CachingBlockLookup blockLookup) {
        int x = startX;
        int y = startY;
        int z = startZ;
        int dx = Math.abs(endX - startX);
        int dy = Math.abs(endY - startY);
        int dz = Math.abs(endZ - startZ);
        int stepX = endX > startX ? 1 : -1;
        int stepY = endY > startY ? 1 : -1;
        int stepZ = endZ > startZ ? 1 : -1;
        double stepCostX = 1.0 / (double)dx;
        double stepCostY = 1.0 / (double)dy;
        double stepCostZ = 1.0 / (double)dz;
        double stepCostSumX = dx == 0 ? Double.POSITIVE_INFINITY : 0.5 / (double)dx;
        double stepCostSumY = dy == 0 ? Double.POSITIVE_INFINITY : 0.5 / (double)dy;
        double stepCostSumZ = dz == 0 ? Double.POSITIVE_INFINITY : 0.5 / (double)dz;
        for (int i = 0; i < dx + dy + dz && (x != endX || y != endY || z != endZ); ++i) {
            if (ShapeUtil.hasCollision(blockLookup, x, y, z, blockLookup.getBlockState(x, y, z))) {
                return true;
            }
            if (PathfindingUtils.doubleEquals(stepCostSumX, stepCostSumY)) {
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y, z, blockLookup.getBlockState(x + stepX, y, z))) {
                    return true;
                }
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y + stepY, z, blockLookup.getBlockState(x + stepX, y + stepY, z))) {
                    return true;
                }
            }
            if (PathfindingUtils.doubleEquals(stepCostSumX, stepCostSumZ)) {
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y, z, blockLookup.getBlockState(x + stepX, y, z))) {
                    return true;
                }
                if (ShapeUtil.hasCollision(blockLookup, x + stepX, y, z + stepZ, blockLookup.getBlockState(x + stepX, y, z + stepZ))) {
                    return true;
                }
            }
            if (PathfindingUtils.doubleEquals(stepCostSumY, stepCostSumZ)) {
                if (ShapeUtil.hasCollision(blockLookup, x, y + stepY, z, blockLookup.getBlockState(x, y + stepY, z))) {
                    return true;
                }
                if (ShapeUtil.hasCollision(blockLookup, x, y + stepY, z + stepZ, blockLookup.getBlockState(x, y + stepY, z + stepZ))) {
                    return true;
                }
            }
            if (stepCostSumX < stepCostSumY) {
                if (stepCostSumX < stepCostSumZ) {
                    x += stepX;
                    stepCostSumX += stepCostX;
                    continue;
                }
                z += stepZ;
                stepCostSumZ += stepCostZ;
                continue;
            }
            if (stepCostSumY < stepCostSumZ) {
                y += stepY;
                stepCostSumY += stepCostY;
                continue;
            }
            z += stepZ;
            stepCostSumZ += stepCostZ;
        }
        return ShapeUtil.hasCollision(blockLookup, endX, endY, endZ, blockLookup.getBlockState(endX, endY, endZ));
    }

    private static boolean doubleEquals(double a, double b) {
        if (Double.isFinite(a) || Double.isFinite(b) || Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) < 5.0E-6;
    }
}

