/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.navigation;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.other.MinecoloniesMinecart;
import com.minecolonies.api.entity.pathfinding.IDynamicHeuristicNavigator;
import com.minecolonies.api.entity.pathfinding.IMinecoloniesNavigator;
import com.minecolonies.api.entity.pathfinding.IStuckHandler;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.entity.pathfinding.PathFindingStatus;
import com.minecolonies.core.entity.pathfinding.PathPointExtended;
import com.minecolonies.core.entity.pathfinding.Pathfinding;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.MovementHandler;
import com.minecolonies.core.entity.pathfinding.navigation.PathingStuckHandler;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobFindTree;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveAwayFromLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveCloseToXNearY;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveToLocation;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobMoveTowards;
import com.minecolonies.core.entity.pathfinding.pathjobs.PathJobRandomPos;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.pathresults.TreePathResult;
import com.minecolonies.core.util.WorkerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MinecoloniesAdvancedPathNavigate
extends AbstractAdvancedPathNavigate
implements IDynamicHeuristicNavigator,
IMinecoloniesNavigator {
    private static final double ON_PATH_SPEED_MULTIPLIER = 1.3;
    public static final double MIN_Y_DISTANCE = 0.001;
    public static final int MAX_SPEED_ALLOWED = 2;
    public static final double MIN_SPEED_ALLOWED = 0.1;
    @Nullable
    private PathResult<? extends AbstractPathJob> pathResult;
    private BlockPos spawnedPos = BlockPos.ZERO;
    private BlockPos safeDestinationPos;
    private IStuckHandler<MinecoloniesAdvancedPathNavigate> stuckHandler;
    private boolean isSneaking = true;
    private double swimSpeedFactor = 1.0;
    private double heuristicAvg = 1.0;
    private int pauseTicks = 0;
    private int pauseTickBackupAmount = 10;
    private BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
    private Vec3 wantedPosition = null;
    private int checkStuckDelay = 10;
    private long finishTime = Long.MAX_VALUE;

    public MinecoloniesAdvancedPathNavigate(@NotNull Mob entity, Level world) {
        super(entity, world);
        entity.moveControl = new MovementHandler(entity);
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        this.getPathingOptions().setEnterDoors(true);
        this.nodeEvaluator.setCanOpenDoors(true);
        this.getPathingOptions().setCanOpenDoors(true);
        this.nodeEvaluator.setCanFloat(true);
        this.getPathingOptions().setCanSwim(true);
        this.stuckHandler = PathingStuckHandler.createStuckHandler().withTakeDamageOnStuck(0.2f).withTeleportSteps(6).withTeleportOnFullStuck();
    }

    @Nullable
    protected PathResult<PathJobMoveAwayFromLocation> walkAwayFrom(BlockPos avoid, double range, double speedFactor, boolean safeDestination) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveAwayFromLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, avoid, (int)range, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), this.ourEntity), null, speedFactor, safeDestination);
    }

    @Override
    @Nullable
    protected PathResult<AbstractPathJob> walkTowards(BlockPos towards, double range, double speedFactor) {
        return this.setPathJob(new PathJobMoveTowards(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), PathfindingUtils.prepareStart((LivingEntity)this.ourEntity), towards, (int)range, this.ourEntity), null, speedFactor, false);
    }

    @Nullable
    protected PathResult<PathJobRandomPos> walkToRandomPos(int range, double speedFactor) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        PathResult<PathJobRandomPos> result = this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, range, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), this.ourEntity), null, speedFactor, true);
        if (result == null) {
            return null;
        }
        ((PathJobRandomPos)result.getJob()).getPathingOptions().withToggleCost((double)1.0).withJumpCost((double)1.0).withDropCost((double)1.0).canDrop = false;
        return result;
    }

    @Nullable
    protected PathResult<PathJobRandomPos> walkToRandomPosAround(int range, double speedFactor, BlockPos pos) {
        PathResult<PathJobRandomPos> result = this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), PathfindingUtils.prepareStart((LivingEntity)this.ourEntity), 3, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), range, this.ourEntity, pos), pos, speedFactor, false);
        if (result == null) {
            return null;
        }
        ((PathJobRandomPos)result.getJob()).getPathingOptions().withToggleCost((double)1.0).withJumpCost((double)1.0).withDropCost((double)1.0).canDrop = false;
        return result;
    }

    protected PathResult<PathJobRandomPos> walkToRandomPos(int range, double speedFactor, Tuple<BlockPos, BlockPos> corners) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        PathResult<PathJobRandomPos> result = this.setPathJob(new PathJobRandomPos(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, range, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), this.ourEntity, (BlockPos)corners.getA(), (BlockPos)corners.getB()), null, speedFactor, true);
        if (result == null) {
            return null;
        }
        ((PathJobRandomPos)result.getJob()).getPathingOptions().withJumpCost((double)1.0).withDropCost((double)1.0).canDrop = false;
        return result;
    }

    @Override
    protected PathResult<PathJobMoveCloseToXNearY> walkCloseToXNearY(BlockPos desiredPosition, BlockPos nearbyPosition, int distToDesired, double speedFactor, boolean safeDestination) {
        PathJobMoveCloseToXNearY pathJob = new PathJobMoveCloseToXNearY(this.ourEntity.level(), desiredPosition, nearbyPosition, 1, this.ourEntity);
        return this.setPathJob(pathJob, desiredPosition, speedFactor, safeDestination);
    }

    @Override
    @Nullable
    public <T extends AbstractPathJob> PathResult<T> setPathJob(@NotNull AbstractPathJob job, BlockPos dest, double speedFactor, boolean safeDestination) {
        if (this.pauseTicks > 0) {
            return null;
        }
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
        }
        super.stop();
        if (dest != null && !dest.equals((Object)BlockPos.ZERO) && job.getStart().distSqr((Vec3i)dest) > 250000.0) {
            Log.getLogger().error("Entity: " + this.ourEntity.getDisplayName().getString() + " is trying to walk too far! distance:" + Math.sqrt(job.getStart().distSqr((Vec3i)dest)) + " from:" + String.valueOf(job.getStart()) + " to:" + String.valueOf(dest), (Throwable)new Exception());
            return null;
        }
        this.finishTime = Long.MAX_VALUE;
        this.originalDestination = dest;
        if (safeDestination) {
            this.safeDestinationPos = dest;
        }
        this.walkSpeedFactor = speedFactor;
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + String.valueOf(this.ourEntity), (Throwable)new Exception());
            return null;
        }
        job.setPathingOptions(this.getPathingOptions());
        this.pathResult = job.getResult();
        this.pathResult.startJob(Pathfinding.getExecutor());
        return this.pathResult;
    }

    public boolean isDone() {
        return (this.pathResult == null || this.pathResult.isDone() && this.pathResult.getStatus() != PathFindingStatus.CALCULATION_COMPLETE) && super.isDone();
    }

    public void tick() {
        if (this.checkStuckDelay-- < 0) {
            this.checkStuckDelay = 10;
            this.stuckHandler.checkStuck(this);
        }
        if (this.pauseTicks > 0) {
            --this.pauseTicks;
        }
        if (this.pathResult != null) {
            if (!this.pathResult.isDone()) {
                return;
            }
            if (this.pathResult.getStatus() == PathFindingStatus.CALCULATION_COMPLETE) {
                this.processCompletedCalculationResult();
                this.wantedPosition = null;
            }
        }
        int oldIndex = this.isDone() ? 0 : this.getPath().getNextNodeIndex();
        this.ourEntity.setYya(0.0f);
        if (this.handleLadders(oldIndex)) {
            this.followThePath();
            return;
        }
        if (this.isSneaking) {
            this.isSneaking = false;
            this.mob.setShiftKeyDown(false);
        }
        if (this.handleRails()) {
            return;
        }
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone()) {
            int currentPathIndex = this.path.getNextNodeIndex();
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 vector3d = this.getTempMobPos();
                Vec3 vector3d1 = this.path.getNextEntityPos((Entity)this.mob);
                if (vector3d.y > vector3d1.y && !this.mob.onGround() && Mth.floor((double)vector3d.x) == Mth.floor((double)vector3d1.x) && Mth.floor((double)vector3d.z) == Mth.floor((double)vector3d1.z)) {
                    this.path.advance();
                }
            }
            if (this.path != null && !this.path.isDone() && (this.wantedPosition == null || currentPathIndex != this.path.getNextNodeIndex() && this.path.getNextNodeIndex() < this.path.getNodeCount())) {
                Vec3 vector3d2 = this.path.getNextEntityPos((Entity)this.mob);
                this.tempPos.set(Mth.floor((double)vector3d2.x), Mth.floor((double)vector3d2.y), Mth.floor((double)vector3d2.z));
                if (this.wantedPosition == null || ChunkPos.asLong((BlockPos)this.tempPos) == this.mob.chunkPosition().toLong() || WorldUtil.isEntityBlockLoaded((LevelAccessor)this.level, (BlockPos)this.tempPos)) {
                    this.wantedPosition = new Vec3(vector3d2.x, MinecoloniesAdvancedPathNavigate.getSmartGroundY((BlockGetter)this.level, this.tempPos, vector3d2.y), vector3d2.z);
                }
            }
            if (this.wantedPosition != null) {
                this.mob.getMoveControl().setWantedPosition(this.wantedPosition.x, this.wantedPosition.y, this.wantedPosition.z, this.speedModifier);
            }
        }
        if (this.pathResult != null && this.isDone()) {
            this.pathResult.setStatus(PathFindingStatus.COMPLETE);
            if (this.ourEntity.level().getGameTime() - this.finishTime > (long)(400 + this.pauseTickBackupAmount)) {
                this.pathResult = null;
            }
        }
    }

    public static double getSmartGroundY(BlockGetter world, BlockPos.MutableBlockPos pos, double orgY) {
        VoxelShape voxelshape;
        BlockState state = world.getBlockState((BlockPos)pos);
        if (!state.isAir()) {
            if (state.getBlock() instanceof FenceGateBlock || state.getBlock() instanceof DoorBlock || state.getBlock() instanceof TrapDoorBlock) {
                return orgY;
            }
            voxelshape = state.getCollisionShape(world, (BlockPos)pos);
            if (!ShapeUtil.isEmpty(voxelshape)) {
                return (double)pos.getY() + ShapeUtil.max(voxelshape, Direction.Axis.Y);
            }
        }
        pos.set(pos.getX(), pos.getY() - 1, pos.getZ());
        state = world.getBlockState((BlockPos)pos);
        if (!state.isAir() && !ShapeUtil.isEmpty(voxelshape = state.getCollisionShape(world, (BlockPos)pos))) {
            return (double)pos.getY() + ShapeUtil.max(voxelshape, Direction.Axis.Y);
        }
        return orgY;
    }

    @Nullable
    protected PathResult<PathJobMoveToLocation> walkTo(BlockPos desiredPos, double speedFactor, boolean safeDestination) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        return this.setPathJob(new PathJobMoveToLocation(CompatibilityUtils.getWorldFromEntity((Entity)this.ourEntity), start, desiredPos, (int)this.ourEntity.getAttribute(Attributes.FOLLOW_RANGE).getValue(), this.ourEntity), desiredPos, speedFactor, safeDestination);
    }

    @Override
    @Deprecated(since="Do not use, always returns true, vanilla override")
    public boolean walkTo(BlockPos pos, double speedFactor) {
        this.walkTo(pos, speedFactor, false);
        return true;
    }

    protected PathFinder createPathFinder(int p_179679_1_) {
        return null;
    }

    protected boolean canUpdatePath() {
        return true;
    }

    @NotNull
    protected Vec3 getTempMobPos() {
        return this.ourEntity.position();
    }

    public Path createPath(BlockPos pos, int p_179680_2_) {
        return null;
    }

    protected boolean canMoveDirectly(Vec3 start, Vec3 end) {
        return !WorkerUtil.isPathBlock(this.level.getBlockState(BlockPos.containing((double)start.x, (double)(start.y - 1.0), (double)start.z)).getBlock()) && super.canMoveDirectly(start, end);
    }

    public double getSpeedFactor() {
        if (this.ourEntity.isInWater()) {
            this.speedModifier = this.walkSpeedFactor * this.swimSpeedFactor;
            return this.speedModifier;
        }
        this.speedModifier = this.walkSpeedFactor;
        return this.walkSpeedFactor;
    }

    public void setSpeedModifier(double speedFactor) {
        if (speedFactor > 2.0 || speedFactor < 0.1) {
            Log.getLogger().error("Tried to set a bad speed:" + speedFactor + " for entity:" + String.valueOf(this.ourEntity), (Throwable)new Exception());
            return;
        }
        this.walkSpeedFactor = speedFactor;
    }

    @Deprecated(since="Do not use, always returns true, vanilla override")
    public boolean moveTo(double x, double y, double z, double speedFactor) {
        this.walkTo(BlockPos.containing((double)x, (double)y, (double)z), speedFactor, false);
        return true;
    }

    public boolean moveTo(Entity entityIn, double speedFactor) {
        return this.walkTo(entityIn.blockPosition(), speedFactor);
    }

    protected void trimPath() {
    }

    @Deprecated(since="Do not use, always returns true, vanilla override")
    public boolean moveTo(@Nullable Path path, double speedFactor) {
        if (path == null) {
            super.stop();
            return false;
        }
        return super.moveTo(this.convertPath(path), speedFactor);
    }

    private Path convertPath(Path path) {
        int pathLength = path.getNodeCount();
        Path tempPath = null;
        if (pathLength > 0 && !(path.getNode(0) instanceof PathPointExtended)) {
            @NotNull PathPointExtended[] newPoints = new PathPointExtended[pathLength];
            for (int i = 0; i < pathLength; ++i) {
                Node point = path.getNode(i);
                newPoints[i] = !(point instanceof PathPointExtended) ? new PathPointExtended(new BlockPos(point.x, point.y, point.z)) : (PathPointExtended)point;
            }
            tempPath = new Path(Arrays.asList(newPoints), path.getTarget(), path.canReach());
        }
        return tempPath == null ? path : tempPath;
    }

    private void processCompletedCalculationResult() {
        if (this.pathResult == null) {
            return;
        }
        if (this.pathResult != null) {
            this.pathResult.setStatus(PathFindingStatus.IN_PROGRESS_FOLLOWING);
        }
        if (this.pathResult.hasPath() && this.pathResult.getPathLength() > 2 && this.pathResult.costPerDist != 1.0) {
            double factor = 1.0 + (double)this.pathResult.getPathLength() / 30.0;
            this.heuristicAvg -= this.heuristicAvg / (50.0 / factor);
            this.heuristicAvg += this.pathResult.costPerDist / (50.0 / factor);
        }
        if (this.pathResult.failedToReachDestination()) {
            this.pauseTicks = this.pauseTickBackupAmount;
            this.pauseTickBackupAmount += 10;
            if (this.pathResult.searchedNodes >= 5000) {
                this.pauseTicks += 50;
            }
        } else {
            this.pauseTickBackupAmount = 10;
        }
        this.moveTo(this.pathResult.getPath(), this.getSpeedFactor());
    }

    private boolean handleLadders(int oldIndex) {
        if (!this.isDone()) {
            @NotNull PathPointExtended pEx = (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex());
            PathPointExtended pExNext = this.getPath().getNodeCount() > this.getPath().getNextNodeIndex() + 1 ? (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex() + 1) : null;
            BlockPos pos = new BlockPos(pEx.x, pEx.y, pEx.z);
            if (pEx.isOnLadder() && pExNext != null && (pEx.y != pExNext.y || this.mob.getY() > (double)pEx.y) && PathfindingUtils.isLadder(this.level.getBlockState(pos), this.pathResult != null ? this.pathResult.getJob().getPathingOptions() : this.getPathingOptions()) && this.level.getBlockState(pos).getFluidState().isEmpty()) {
                return this.handlePathPointOnLadder(pEx);
            }
            if (this.ourEntity.isInWater()) {
                return this.handleEntityInWater(oldIndex, pEx);
            }
            if (this.level.random.nextInt(20) == 0) {
                this.speedModifier = !pEx.isOnLadder() && pExNext != null && pExNext.isOnLadder() ? this.getSpeedFactor() / 4.0 : (WorkerUtil.isPathBlock(this.level.getBlockState(this.findBlockUnderEntity((Entity)this.ourEntity)).getBlock()) ? 1.3 * this.getSpeedFactor() : this.getSpeedFactor());
            }
        }
        return false;
    }

    private BlockPos findBlockUnderEntity(@NotNull Entity parEntity) {
        int blockX = (int)Math.round(parEntity.getX());
        int blockY = Mth.floor((double)(parEntity.getY() - 0.2));
        int blockZ = (int)Math.round(parEntity.getZ());
        return new BlockPos(blockX, blockY, blockZ);
    }

    private boolean handleRails() {
        if (!this.isDone()) {
            PathPointExtended pExNext;
            @NotNull PathPointExtended pEx = (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex());
            PathPointExtended pathPointExtended = pExNext = this.getPath().getNodeCount() > this.getPath().getNextNodeIndex() + 1 ? (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex() + 1) : null;
            if (pExNext != null && pEx.x == pExNext.x && pEx.z == pExNext.z) {
                PathPointExtended pathPointExtended2 = pExNext = this.getPath().getNodeCount() > this.getPath().getNextNodeIndex() + 2 ? (PathPointExtended)this.getPath().getNode(this.getPath().getNextNodeIndex() + 2) : null;
            }
            if (pEx.isOnRails() || pEx.isRailsExit()) {
                return this.handlePathOnRails(pEx, pExNext);
            }
        }
        return false;
    }

    private boolean handlePathOnRails(PathPointExtended pEx, PathPointExtended pExNext) {
        BlockPos blockPos;
        if (pEx.isRailsEntry()) {
            blockPos = new BlockPos(pEx.x, pEx.y, pEx.z);
            if (!this.spawnedPos.equals((Object)blockPos)) {
                Entity entity;
                BlockState blockstate = this.level.getBlockState(blockPos);
                RailShape railshape = blockstate.getBlock() instanceof BaseRailBlock ? ((BaseRailBlock)blockstate.getBlock()).getRailDirection(blockstate, (BlockGetter)this.level, blockPos, null) : RailShape.NORTH_SOUTH;
                double yOffset = 0.0;
                if (railshape.isAscending()) {
                    yOffset = 0.5;
                }
                if ((entity = this.mob.getVehicle()) instanceof MinecoloniesMinecart) {
                    MinecoloniesMinecart ourMinecart = (MinecoloniesMinecart)entity;
                    ourMinecart.setHurtDir(1);
                } else {
                    MinecoloniesMinecart minecart = (MinecoloniesMinecart)ModEntities.MINECART.create(this.level);
                    double x = (double)pEx.x + 0.5;
                    double y = (double)pEx.y + 0.625 + yOffset;
                    double z = (double)pEx.z + 0.5;
                    minecart.setPos(x, y, z);
                    minecart.setDeltaMovement(Vec3.ZERO);
                    minecart.xo = x;
                    minecart.yo = y;
                    minecart.zo = z;
                    this.level.addFreshEntity((Entity)minecart);
                    minecart.setHurtDir(1);
                    this.mob.startRiding((Entity)minecart, true);
                }
                this.spawnedPos = blockPos;
            }
        } else {
            this.spawnedPos = BlockPos.ZERO;
        }
        if (this.mob.getVehicle() instanceof MinecoloniesMinecart && pExNext != null) {
            blockPos = new BlockPos(pEx.x, pEx.y, pEx.z);
            BlockPos blockPosNext = new BlockPos(pExNext.x, pExNext.y, pExNext.z);
            Vec3 motion = this.mob.getVehicle().getDeltaMovement();
            switch (BlockPosUtil.getXZFacing(blockPos, blockPosNext).getOpposite()) {
                case EAST: {
                    double forward = Math.min(Math.max(motion.x() - 0.01, -1.0), 0.0);
                    this.mob.getVehicle().setDeltaMovement(motion.add(forward == -1.0 ? -1.0 : -0.01, 0.0, 0.0));
                    break;
                }
                case WEST: {
                    double forward = Math.max(Math.min(motion.x() + 0.01, 1.0), 0.0);
                    this.mob.getVehicle().setDeltaMovement(motion.add(forward == 1.0 ? 1.0 : 0.01, 0.0, 0.0));
                    break;
                }
                case NORTH: {
                    double forward = Math.max(Math.min(motion.z() + 0.01, 1.0), 0.0);
                    this.mob.getVehicle().setDeltaMovement(motion.add(0.0, 0.0, forward == 1.0 ? 1.0 : 0.01));
                    break;
                }
                case SOUTH: {
                    double forward = Math.min(Math.max(motion.z() - 0.01, -1.0), 0.0);
                    this.mob.getVehicle().setDeltaMovement(motion.add(0.0, 0.0, forward == -1.0 ? -1.0 : -0.01));
                    break;
                }
            }
        }
        return false;
    }

    private boolean handlePathPointOnLadder(PathPointExtended pEx) {
        Vec3 vec3 = this.getPath().getNextEntityPos((Entity)this.ourEntity);
        BlockPos entityPos = this.ourEntity.blockPosition();
        if (vec3.distanceToSqr(this.ourEntity.getX(), vec3.y, this.ourEntity.getZ()) < 0.6 && Math.abs(vec3.y - (double)entityPos.getY()) <= 2.0) {
            double newSpeed = 0.3;
            switch (pEx.getLadderFacing()) {
                case NORTH: {
                    vec3 = vec3.add(0.0, 0.0, 0.8);
                    break;
                }
                case SOUTH: {
                    vec3 = vec3.add(0.0, 0.0, -0.8);
                    break;
                }
                case WEST: {
                    vec3 = vec3.add(0.8, 0.8, 0.0);
                    break;
                }
                case EAST: {
                    vec3 = vec3.add(-0.8, 0.0, 0.0);
                    break;
                }
                case UP: {
                    vec3 = vec3.add(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    newSpeed = 0.0;
                    if (!this.isSneaking) {
                        this.mob.setShiftKeyDown(true);
                        this.isSneaking = true;
                    }
                    this.ourEntity.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, 0.2);
                    this.wantedPosition = vec3;
                }
            }
            if (newSpeed > 0.0) {
                if (!(this.level.getBlockState(this.ourEntity.blockPosition()).getBlock() instanceof LadderBlock)) {
                    this.ourEntity.setDeltaMovement(this.ourEntity.getDeltaMovement().add(0.0, 0.1, 0.0));
                }
                this.ourEntity.getMoveControl().setWantedPosition(vec3.x, vec3.y, vec3.z, newSpeed);
                this.wantedPosition = vec3;
            } else {
                if (!PathfindingUtils.isLadder(this.level.getBlockState(entityPos.below()), this.getPathingOptions()) && !(this.ourEntity.getY() > (double)pEx.y)) {
                    return false;
                }
                this.ourEntity.setYya(-0.5f);
                return true;
            }
        }
        return false;
    }

    private boolean handleEntityInWater(int oldIndex, PathPointExtended pEx) {
        if (!this.ourEntity.getEyeInFluidType().isAir()) {
            return false;
        }
        int curIndex = this.getPath().getNextNodeIndex();
        if (curIndex > 0 && curIndex + 1 < this.getPath().getNodeCount() && this.getPath().getNode((int)(curIndex - 1)).y != pEx.y) {
            oldIndex = curIndex + 1;
        }
        this.getPath().setNextNodeIndex(oldIndex);
        Vec3 Vector3d = this.getPath().getNextEntityPos((Entity)this.ourEntity);
        Vec3 vec3 = new Vec3(this.ourEntity.getX(), Vector3d.y, this.ourEntity.getZ());
        if (Vector3d.distanceToSqr(vec3) < 0.1 && Math.abs(this.ourEntity.getY() - Vector3d.y) < 0.5) {
            this.getPath().advance();
            if (this.isDone()) {
                return true;
            }
            Vector3d = this.getPath().getNextEntityPos((Entity)this.ourEntity);
        }
        this.ourEntity.getMoveControl().setWantedPosition(Vector3d.x, Vector3d.y, Vector3d.z, this.getSpeedFactor());
        this.wantedPosition = Vector3d;
        return false;
    }

    protected void followThePath() {
        Vec3 next;
        this.getSpeedFactor();
        int curNode = this.path.getNextNodeIndex();
        int curNodeNext = curNode + 1;
        if (curNodeNext < this.path.getNodeCount()) {
            if (!(this.path.getNode(curNode) instanceof PathPointExtended)) {
                this.path = this.convertPath(this.path);
            }
            PathPointExtended pEx = (PathPointExtended)this.path.getNode(curNode);
            PathPointExtended pExNext = (PathPointExtended)this.path.getNode(curNodeNext);
            if (pEx.isOnLadder() && pEx.getLadderFacing() == Direction.DOWN && !pExNext.isOnLadder()) {
                Vec3 vec3 = this.getTempMobPos();
                if (vec3.y - (double)pEx.y < 0.001) {
                    this.path.setNextNodeIndex(curNodeNext);
                }
                return;
            }
            if (!pEx.isOnRails() && this.ourEntity.getVehicle() != null) {
                Entity entity = this.ourEntity.getVehicle();
                this.ourEntity.stopRiding();
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        this.maxDistanceToWaypoint = 0.5f;
        boolean wentAhead = false;
        boolean isTracking = PathfindingUtils.trackingMap.containsValue(this.ourEntity.getUUID());
        HashSet<BlockPos> reached = null;
        if (isTracking) {
            reached = new HashSet<BlockPos>();
        }
        for (int i = this.path.getNextNodeIndex(); i < Math.min(this.path.getNodeCount(), this.path.getNextNodeIndex() + 4); ++i) {
            next = this.path.getEntityPosAtNode((Entity)this.mob, i);
            if (!(Math.abs(this.mob.getX() - next.x) < (double)this.maxDistanceToWaypoint - Math.abs(this.mob.getY() - next.y) * 0.1) || !(Math.abs(this.mob.getZ() - next.z) < (double)this.maxDistanceToWaypoint - Math.abs(this.mob.getY() - next.y) * 0.1) || !(Math.abs(this.mob.getY() - next.y) <= 1.0)) continue;
            this.path.advance();
            wentAhead = true;
            if (!isTracking) continue;
            Node point = this.path.getNode(i);
            reached.add(new BlockPos(point.x, point.y, point.z));
        }
        if (isTracking) {
            PathfindingUtils.syncDebugReachedPositions(reached, this.pathResult.getDebugWatchers());
            reached.clear();
        }
        if (this.path.isDone()) {
            this.onPathFinish();
            return;
        }
        if (wentAhead) {
            return;
        }
        if (curNode >= this.path.getNodeCount() || curNode <= 1) {
            return;
        }
        Vec3 curr = this.path.getEntityPosAtNode((Entity)this.mob, curNode - 1);
        next = this.path.getEntityPosAtNode((Entity)this.mob, curNode);
        if (this.mob.position().distanceTo(curr) >= 2.0 && this.mob.position().distanceTo(next) >= 2.0) {
            for (int currentIndex = curNode - 1; currentIndex > 0; --currentIndex) {
                Vec3 tempoPos = this.path.getEntityPosAtNode((Entity)this.mob, currentIndex);
                if (this.mob.position().distanceTo(tempoPos) <= 1.0) {
                    this.path.setNextNodeIndex(currentIndex);
                    continue;
                }
                if (!isTracking) continue;
                reached.add(BlockPos.containing((double)tempoPos.x, (double)tempoPos.y, (double)tempoPos.z));
            }
        }
        if (isTracking) {
            PathfindingUtils.syncDebugReachedPositions(reached, this.pathResult.getDebugWatchers());
            reached.clear();
        }
    }

    private void onPathFinish() {
        this.finishTime = this.ourEntity.level().getGameTime();
        super.stop();
    }

    public void recomputePath() {
    }

    protected void doStuckDetection(@NotNull Vec3 positionVec3) {
    }

    public void stop() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
            this.pathResult = null;
            if (this.ourEntity.getVehicle() != null) {
                Entity entity = this.ourEntity.getVehicle();
                this.ourEntity.stopRiding();
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        this.safeDestinationPos = BlockPos.ZERO;
        this.stuckHandler.resetGlobalStuckTimers();
        super.stop();
    }

    @Override
    public void recalc() {
        if (this.pathResult != null) {
            this.pathResult.cancel();
            this.pathResult.setStatus(PathFindingStatus.CANCELLED);
        }
        super.stop();
    }

    @Override
    public TreePathResult walkToTree(BlockPos startRestriction, BlockPos endRestriction, double speed, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        BlockPos furthestRestriction = BlockPosUtil.getFurthestCorner(start, startRestriction, endRestriction);
        PathJobFindTree job = new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.mob), start, startRestriction, endRestriction, furthestRestriction, excludedTrees, dyntreesize, colony, this.ourEntity);
        return (TreePathResult)this.setPathJob(job, null, speed, true);
    }

    @Override
    public TreePathResult walkToTree(int range, double speed, List<ItemStorage> excludedTrees, int dyntreesize, IColony colony) {
        @NotNull BlockPos start = PathfindingUtils.prepareStart((LivingEntity)this.ourEntity);
        BlockPos buildingPos = ((AbstractEntityCitizen)this.mob).getCitizenColonyHandler().getWorkBuilding().getPosition();
        if (BlockPosUtil.getDistance2D(buildingPos, this.mob.blockPosition()) > (long)(range * 4)) {
            start = buildingPos;
        }
        return (TreePathResult)this.setPathJob(new PathJobFindTree(CompatibilityUtils.getWorldFromEntity((Entity)this.mob), start, buildingPos, range, excludedTrees, dyntreesize, colony, this.ourEntity), null, speed, true);
    }

    @Nullable
    public PathResult<PathJobMoveToLocation> walkToEntity(@NotNull Entity e, double speed) {
        return this.walkTo(e.blockPosition(), speed, false);
    }

    @Nullable
    public PathResult<PathJobMoveAwayFromLocation> moveAwayFromLivingEntity(@NotNull Entity e, double distance, double speed) {
        return this.walkAwayFrom(e.blockPosition(), distance, speed, true);
    }

    public void setCanFloat(boolean canSwim) {
        super.setCanFloat(canSwim);
        this.getPathingOptions().setCanSwim(canSwim);
    }

    @Override
    public BlockPos getSafeDestination() {
        return this.safeDestinationPos;
    }

    @Override
    public void setSafeDestinationPos(BlockPos pos) {
        this.safeDestinationPos = pos;
    }

    @Override
    public void setStuckHandler(IStuckHandler stuckHandler) {
        this.stuckHandler = stuckHandler;
    }

    @Override
    public void setSwimSpeedFactor(double factor) {
        this.swimSpeedFactor = factor;
    }

    @Override
    public double getAvgHeuristicModifier() {
        return this.heuristicAvg;
    }

    @Override
    public void setPauseTicks(int pauseTicks) {
        if (pauseTicks > 2400) {
            Log.getLogger().warn("Tried to pause entity pathfinding for " + String.valueOf(this.mob) + " too long for " + pauseTicks + " ticks.", (Throwable)new Exception());
            this.pauseTicks = 50;
        } else {
            this.pauseTicks = pauseTicks;
        }
    }

    @Override
    public PathResult getPathResult() {
        return this.pathResult;
    }

    @Override
    public IStuckHandler<MinecoloniesAdvancedPathNavigate> getStuckHandler() {
        return this.stuckHandler;
    }
}

