/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.AbstractPathJob;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class PathJobMoveAwayFromLocation
extends AbstractPathJob
implements IDestinationPathJob {
    @NotNull
    protected final BlockPos avoid;
    protected final int avoidDistance;
    private BlockPos preferredDirection;

    public PathJobMoveAwayFromLocation(Level world, @NotNull BlockPos start, @NotNull BlockPos avoid, int avoidDistance, int range, Mob entity) {
        super(world, start, range, new PathResult(), entity);
        IColony colony;
        this.avoid = new BlockPos((Vec3i)avoid);
        this.avoidDistance = avoidDistance;
        this.preferredDirection = entity.blockPosition().offset((Vec3i)entity.blockPosition().subtract((Vec3i)avoid).multiply(range));
        if (entity instanceof AbstractEntityCitizen && (colony = ((AbstractEntityCitizen)entity).getCitizenColonyHandler().getColonyOrRegister()) != null) {
            this.preferredDirection = colony.getCenter();
        }
    }

    @Override
    protected double computeHeuristic(int x, int y, int z) {
        return BlockPosUtil.dist(this.preferredDirection, x, y, z);
    }

    @Override
    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        if (BlockPosUtil.dist(this.avoid, x, y, z) < 3.0) {
            return cost + 100.0;
        }
        return cost;
    }

    @Override
    protected boolean isAtDestination(@NotNull MNode n) {
        return BlockPosUtil.dist(this.avoid, n.x, n.y, n.z) > (double)this.avoidDistance && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(n.x, n.y - 1, n.z), (BlockPos)this.tempWorldPos.set(n.x, n.y - 1, n.z), this.getPathingOptions()) == SurfaceType.WALKABLE;
    }

    @Override
    protected double getEndNodeScore(@NotNull MNode n) {
        return -BlockPosUtil.dist(this.avoid, n.x, n.y, n.z);
    }

    @Override
    public void setPathingOptions(PathingOptions pathingOptions) {
        super.setPathingOptions(pathingOptions);
        pathingOptions.dropCost = 5.0;
    }

    @Override
    public BlockPos getDestination() {
        return this.preferredDirection;
    }

    public static boolean isJobFor(AbstractPathJob job, int avoidDistance, BlockPos toAvoid) {
        if (job instanceof PathJobMoveAwayFromLocation) {
            PathJobMoveAwayFromLocation pathJob = (PathJobMoveAwayFromLocation)job;
            return pathJob.avoidDistance == avoidDistance && pathJob.avoid.equals((Object)toAvoid);
        }
        return false;
    }
}

