/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.event;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.compatibility.CraftingTagAuditor;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.datalistener.QuestJsonListener;
import com.minecolonies.core.network.messages.client.UpdateClientWithCompatibilityMessage;
import com.minecolonies.core.util.FurnaceRecipes;
import com.mojang.authlib.GameProfile;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RecipesUpdatedEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import org.jetbrains.annotations.NotNull;

public class DataPackSyncEventHandler {

    public static class ClientEvents {
        @SubscribeEvent
        public static void onRecipesLoaded(@NotNull RecipesUpdatedEvent event) {
            GameProfile owner;
            IntegratedServer server = Minecraft.getInstance().getSingleplayerServer();
            GameProfile gameProfile = owner = server == null ? null : server.getSingleplayerProfile();
            if (owner != null && owner == Minecraft.getInstance().player.getGameProfile()) {
                return;
            }
            FurnaceRecipes.getInstance().loadRecipes(event.getRecipeManager(), (Level)Minecraft.getInstance().level);
        }
    }

    public static class ServerEvents {
        private static boolean loaded = false;

        private static void discoverCompatLists(@NotNull MinecraftServer server) {
            Log.getLogger().warn("Starting Compat Discovery");
            FurnaceRecipes.getInstance().loadRecipes(server.getRecipeManager(), (Level)server.overworld());
            IMinecoloniesAPI.getInstance().getColonyManager().getCompatibilityManager().discover(server.getRecipeManager(), (Level)server.overworld());
            CustomRecipeManager.getInstance().resolveTemplates((HolderLookup.Provider)server.registryAccess());
            CustomRecipeManager.getInstance().buildLootData((Level)server.overworld());
        }

        private static void sendPackets(@NotNull ServerPlayer player, @NotNull UpdateClientWithCompatibilityMessage compatMsg) {
            compatMsg.sendToPlayer(player);
            CustomRecipeManager.getInstance().sendCustomRecipeManagerPackets(player);
            IGlobalResearchTree.getInstance().sendGlobalResearchTreePackets(player);
            QuestJsonListener.sendGlobalQuestPackets(player);
            DiseasesListener.sendGlobalDiseasesPackets(player);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onDataPackSync(OnDatapackSyncEvent event) {
            CustomRecipeManager recipeManager = CustomRecipeManager.getInstance();
            MinecraftServer server = event.getPlayerList().getServer();
            GameProfile owner = server.getSingleplayerProfile();
            if (event.getPlayer() == null) {
                ServerEvents.discoverCompatLists(server);
                UpdateClientWithCompatibilityMessage compatMsg = new UpdateClientWithCompatibilityMessage((RegistryAccess)server.registryAccess());
                for (ServerPlayer player : event.getPlayerList().getPlayers()) {
                    if (player.getGameProfile() == owner) continue;
                    ServerEvents.sendPackets(player, compatMsg);
                }
            } else if (event.getPlayer().getGameProfile() != owner) {
                ServerEvents.sendPackets(event.getPlayer(), new UpdateClientWithCompatibilityMessage((RegistryAccess)server.registryAccess()));
            }
            if (((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).auditCraftingTags.get()).booleanValue() && (event.getPlayer() == null || event.getPlayerList().getPlayers().isEmpty())) {
                CraftingTagAuditor.doRecipeAudit(server, recipeManager);
            }
        }

        public static void load(@NotNull MinecraftServer server) {
            if (loaded) {
                return;
            }
            loaded = true;
            ServerEvents.discoverCompatLists(server);
        }

        public static void reset() {
            loaded = false;
        }
    }
}

