/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.core.generation.CustomRecipeProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DefaultConcreteMixerCraftingProvider
extends CustomRecipeProvider {
    public DefaultConcreteMixerCraftingProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "DefaultConcreteMixerCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        ArrayList<ItemStorage> input = new ArrayList<ItemStorage>();
        input.add(new ItemStorage(new ItemStack((ItemLike)Items.SAND, 4)));
        input.add(new ItemStorage(new ItemStack((ItemLike)Items.GRAVEL, 4)));
        for (DyeColor color : DyeColor.values()) {
            String prefix = color.name().toLowerCase(Locale.US);
            Item powder = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(prefix + "_concrete_powder")));
            Item concrete = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(prefix + "_concrete")));
            Item dye = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)(prefix + "_dye")));
            if (powder == null || concrete == null || dye == null) {
                throw new IllegalStateException("Missing items for " + color.getSerializedName());
            }
            ArrayList<ItemStorage> customInput = new ArrayList<ItemStorage>(input);
            customInput.add(new ItemStorage(new ItemStack((ItemLike)dye)));
            this.recipe(ModJobs.CONCRETE_ID.getPath(), "custom", BuiltInRegistries.ITEM.getKey((Object)powder).getPath()).inputs(customInput).result(new ItemStack((ItemLike)powder, 8)).build(consumer);
            this.recipe(ModJobs.CONCRETE_ID.getPath(), "custom", BuiltInRegistries.ITEM.getKey((Object)concrete).getPath()).inputs(Collections.singletonList(new ItemStorage(new ItemStack((ItemLike)powder)))).result(new ItemStack((ItemLike)concrete)).build(consumer);
        }
    }
}

