/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.core.generation.CustomRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DefaultMechanicCraftingProvider
extends CustomRecipeProvider {
    private static final String MECHANIC = ModJobs.MECHANIC_ID.getPath();

    public DefaultMechanicCraftingProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "DefaultMechanicCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        this.recipe(MECHANIC, "crafting", "gate_wood").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.OAK_LOG, 5)))).result(new ItemStack((ItemLike)ModItems.woodgate)).showTooltip(true).build(consumer);
        this.recipe(MECHANIC, "crafting", "gate_iron").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.IRON_NUGGET, 5)))).result(new ItemStack((ItemLike)ModItems.irongate)).showTooltip(true).build(consumer);
        this.recipe(MECHANIC, "crafting", "rails").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.STICK, 5)), new ItemStorage(new ItemStack((ItemLike)Items.IRON_INGOT, 2)))).result(new ItemStack((ItemLike)Items.RAIL, 16)).minBuildingLevel(3).build(consumer);
        this.recipe(MECHANIC, "crafting", "lantern").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.IRON_NUGGET, 3)), new ItemStorage(new ItemStack((ItemLike)Items.GLASS_BOTTLE)), new ItemStorage(new ItemStack((ItemLike)Items.TORCH)))).result(new ItemStack((ItemLike)Items.LANTERN)).minBuildingLevel(3).build(consumer);
        this.recipe(MECHANIC, "crafting", "soul_lantern").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.IRON_NUGGET, 3)), new ItemStorage(new ItemStack((ItemLike)Items.GLASS_BOTTLE)), new ItemStorage(new ItemStack((ItemLike)Items.SOUL_TORCH)))).result(new ItemStack((ItemLike)Items.SOUL_LANTERN)).minBuildingLevel(3).build(consumer);
        this.deoxidize(consumer, Items.OXIDIZED_COPPER, Items.WEATHERED_COPPER);
        this.deoxidize(consumer, Items.OXIDIZED_CUT_COPPER, Items.WEATHERED_CUT_COPPER);
        this.deoxidize(consumer, Items.WEATHERED_COPPER, Items.EXPOSED_COPPER);
        this.deoxidize(consumer, Items.WEATHERED_CUT_COPPER, Items.EXPOSED_CUT_COPPER);
        this.deoxidize(consumer, Items.EXPOSED_COPPER, Items.COPPER_BLOCK);
        this.deoxidize(consumer, Items.EXPOSED_CUT_COPPER, Items.CUT_COPPER);
    }

    private void deoxidize(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer, @NotNull Item input, @NotNull Item output) {
        this.recipe(MECHANIC, "crafting", "deoxidize_" + BuiltInRegistries.ITEM.getKey((Object)input).getPath()).inputs(List.of(new ItemStorage(new ItemStack((ItemLike)input)))).result(new ItemStack((ItemLike)output)).requiredTool((EquipmentTypeEntry)ModEquipmentTypes.axe.get()).build(consumer);
    }
}

