/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.component.AdventureData;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.generation.CustomRecipeAndLootTableProvider;
import com.minecolonies.core.generation.CustomRecipeProvider;
import com.minecolonies.core.generation.SimpleLootTableProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class DefaultNetherWorkerLootProvider
extends CustomRecipeAndLootTableProvider {
    public static final String NETHERWORKER = ModJobs.NETHERWORKER_ID.getPath();
    private static final int MAX_BUILDING_LEVEL = 5;
    private final List<LootTable.Builder> levels = new ArrayList<LootTable.Builder>();

    public DefaultNetherWorkerLootProvider(@NotNull PackOutput packOutput, @NotNull CompletableFuture<HolderLookup.Provider> providerFuture) {
        super(packOutput, providerFuture);
        for (int buildingLevel = 1; buildingLevel <= 5; ++buildingLevel) {
            this.levels.add(this.createTripLoot(buildingLevel));
        }
    }

    private LootTable.Builder createTripLoot(int buildingLevel) {
        return new LootTable.Builder().withPool(this.createBlocksPool(buildingLevel)).withPool(this.createMobsPool(buildingLevel));
    }

    @NotNull
    private LootPool.Builder createBlocksPool(int buildingLevel) {
        LootPool.Builder blocks = new LootPool.Builder().setRolls((NumberProvider)UniformGenerator.between((float)3.0f, (float)10.0f)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.3f, (float)0.3f));
        blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERRACK).setWeight(20).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)5.0f, (float)25.0f))));
        blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SOUL_SAND).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)7.0f))));
        blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SOUL_SOIL).setWeight(8).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)5.0f))));
        blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GRAVEL).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)10.0f))));
        blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_QUARTZ_ORE).setWeight(15).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)4.0f))));
        if (buildingLevel >= 2) {
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).setWeight(3).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BROWN_MUSHROOM).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_MUSHROOM).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRIMSON_NYLIUM).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRIMSON_FUNGUS).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CRIMSON_STEM).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 3) {
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BASALT).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_NYLIUM).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)1.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_FUNGUS).setWeight(10).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WARPED_STEM).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OCHRE_FROGLIGHT).setWeight(2));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PEARLESCENT_FROGLIGHT).setWeight(1));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.VERDANT_FROGLIGHT).setWeight(1));
        }
        if (buildingLevel >= 4) {
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_GOLD_ORE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLACKSTONE).setWeight(5).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)3.0f))));
        }
        if (buildingLevel >= 5) {
            blocks.add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ANCIENT_DEBRIS).setWeight(1).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f))));
        }
        return blocks;
    }

    @NotNull
    private LootPool.Builder createMobsPool(int buildingLevel) {
        LootPool.Builder mobs = new LootPool.Builder().setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)).setBonusRolls((NumberProvider)UniformGenerator.between((float)0.1f, (float)0.1f));
        mobs.add((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.ZOMBIFIED_PIGLIN, 5, 5).setWeight(5500).setQuality(-10));
        mobs.add((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.MAGMA_CUBE, 3, 4).setWeight(300).setQuality(10));
        mobs.add((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.HOGLIN, 3, 5).setWeight(500).setQuality(-1));
        mobs.add((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.GHAST, 12, 5).setWeight(300).setQuality(-3));
        mobs.add((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.ENDERMAN, 7, 5).setWeight(300).setQuality(-3));
        mobs.add((LootPoolEntryContainer.Builder)this.createAdventureToken(EntityType.BLAZE, 5, 10).setWeight(100).setQuality(1));
        return mobs;
    }

    private LootPoolSingletonContainer.Builder<?> createAdventureToken(@NotNull EntityType<?> mob, int damage_done, int xp_gained) {
        ItemStack stack = new ItemStack((ItemLike)ModItems.adventureToken);
        new AdventureData(mob, damage_done, xp_gained).writeToItemStack(stack);
        return SimpleLootTableProvider.itemStack(stack);
    }

    @NotNull
    public String getName() {
        return "NetherWorkerLootProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        List<ItemStorage> inputs = Arrays.asList(new ItemStorage(new ItemStack((ItemLike)Items.COBBLESTONE, 64)), new ItemStorage(new ItemStack((ItemLike)Items.TORCH, 32)), new ItemStorage(new ItemStack((ItemLike)Items.LADDER, 16)));
        for (int i = 0; i < this.levels.size(); ++i) {
            int buildingLevel = i + 1;
            List<LootTableAnalyzer.LootDrop> drops = LootTableAnalyzer.toDrops(this.provider, (Holder<LootTable>)Holder.direct((Object)this.levels.get(i).build()));
            Stream<ItemStack> loot = drops.stream().flatMap(drop -> drop.getItemStacks().stream().sorted(Comparator.comparing(ItemStack::getCount).reversed().thenComparing(ItemStack::getDescriptionId)).map(ItemStack::getItem));
            this.recipe(NETHERWORKER, "custom", "trip" + buildingLevel).minBuildingLevel(buildingLevel).maxBuildingLevel(buildingLevel).inputs(inputs).secondaryOutputs(loot.map(ItemStack::new).collect(Collectors.toList())).lootTable(new ResourceLocation("minecolonies", "recipes/" + NETHERWORKER + "/trip" + buildingLevel)).build(consumer);
        }
        this.recipe(NETHERWORKER, "custom", "lava").inputs(Collections.singletonList(new ItemStorage(new ItemStack((ItemLike)Items.BUCKET)))).result(new ItemStack((ItemLike)Items.LAVA_BUCKET)).build(consumer);
    }

    @Override
    @NotNull
    protected List<LootTableProvider.SubProviderEntry> registerTables() {
        return List.of(new LootTableProvider.SubProviderEntry(provider -> builder -> {
            for (int i = 0; i < this.levels.size(); ++i) {
                int buildingLevel = i + 1;
                builder.accept(DefaultNetherWorkerLootProvider.table(new ResourceLocation("minecolonies", "recipes/" + NETHERWORKER + "/trip" + buildingLevel)), this.levels.get(i));
            }
        }, LootContextParamSets.ALL_PARAMS));
    }
}

