/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.items.component.BuildingId;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBeekeeper;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.client.colony.ColonyViewBuildingViewMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import org.jetbrains.annotations.NotNull;

public class ItemScepterBeekeeper
extends AbstractItemMinecolonies
implements IBlockOverlayItem {
    private static final int RED_OVERLAY = -65536;
    private static final int YELLOW_OVERLAY = -256;

    public ItemScepterBeekeeper(Item.Properties properties) {
        super("scepterbeekeeper", properties.stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext useContext) {
        if (useContext.getLevel().isClientSide) {
            return InteractionResult.FAIL;
        }
        Player player = useContext.getPlayer();
        ItemStack scepter = useContext.getPlayer().getItemInHand(useContext.getHand());
        IBuilding iBuilding = BuildingId.readBuildingFromItemStack(scepter);
        if (!(iBuilding instanceof BuildingBeekeeper)) {
            return InteractionResult.FAIL;
        }
        BuildingBeekeeper building = (BuildingBeekeeper)iBuilding;
        if (useContext.getLevel().getBlockState(useContext.getClickedPos()).getBlock() instanceof BeehiveBlock) {
            BlockPos pos;
            Set<BlockPos> positions = building.getHives();
            if (positions.contains(pos = useContext.getClickedPos())) {
                MessageUtils.format("item.minecolonies.scepterbeekeeper.removehive", new Object[0]).sendTo(useContext.getPlayer());
                building.removeHive(pos);
                SoundUtils.playSoundForPlayer((ServerPlayer)player, (SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), 1.0f, 0.5f);
                new ColonyViewBuildingViewMessage(building).sendToPlayer((ServerPlayer)player);
            } else {
                if (positions.size() < building.getMaximumHives()) {
                    MessageUtils.format("item.minecolonies.scepterbeekeeper.addhive", new Object[0]).sendTo(useContext.getPlayer());
                    building.addHive(pos);
                    SoundUtils.playSuccessSound(player, player.blockPosition());
                    new ColonyViewBuildingViewMessage(building).sendToPlayer((ServerPlayer)player);
                }
                if (positions.size() >= building.getMaximumHives()) {
                    MessageUtils.format("item.minecolonies.scepterbeekeeper.maxhives", new Object[0]).sendTo(useContext.getPlayer());
                    player.getInventory().removeItemNoUpdate(player.getInventory().selected);
                }
            }
        } else {
            player.getInventory().removeItemNoUpdate(player.getInventory().selected);
        }
        return super.useOn(useContext);
    }

    @Override
    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        IBuildingView iBuildingView = BuildingId.readBuildingViewFromItemStack(stack);
        if (iBuildingView instanceof BuildingBeekeeper.View) {
            BuildingBeekeeper.View hut = (BuildingBeekeeper.View)iBuildingView;
            ArrayList<IBlockOverlayItem.OverlayBox> overlays = new ArrayList<IBlockOverlayItem.OverlayBox>();
            overlays.add(new IBlockOverlayItem.OverlayBox(hut.getPosition(), -65536, 0.02f, true));
            for (BlockPos hive : hut.getHives()) {
                overlays.add(new IBlockOverlayItem.OverlayBox(hive, -256, 0.04f, true));
            }
            return overlays;
        }
        return Collections.emptyList();
    }
}

