/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.WindowSuggestBuildTool;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class OpenSuggestionWindowMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"open_suggestion_window", OpenSuggestionWindowMessage::new);
    private final BlockState state;
    private final BlockPos pos;
    private final ItemStack stack;

    public OpenSuggestionWindowMessage(BlockState state, BlockPos pos, ItemStack stack) {
        super(TYPE);
        this.state = state;
        this.pos = pos;
        this.stack = stack;
    }

    protected OpenSuggestionWindowMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.state = Block.stateById((int)buf.readInt());
        this.pos = buf.readBlockPos();
        this.stack = Utils.deserializeCodecMess(buf);
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(Block.getId((BlockState)this.state));
        buf.writeBlockPos(this.pos);
        Utils.serializeCodecMess(buf, this.stack);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        new WindowSuggestBuildTool(this.pos, this.state, this.stack).open();
    }
}

