/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class VanillaParticleMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"vanilla_particle_message", VanillaParticleMessage::new);
    private final double x;
    private final double y;
    private final double z;
    private final SimpleParticleType type;

    public VanillaParticleMessage(double x, double y, double z, SimpleParticleType type) {
        super(TYPE);
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    protected VanillaParticleMessage(RegistryFriendlyByteBuf byteBuf, PlayMessageType<?> type) {
        super(byteBuf, type);
        this.x = byteBuf.readDouble();
        this.y = byteBuf.readDouble();
        this.z = byteBuf.readDouble();
        this.type = (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(byteBuf.readResourceLocation());
    }

    protected void toBytes(RegistryFriendlyByteBuf byteBuf) {
        byteBuf.writeDouble(this.x);
        byteBuf.writeDouble(this.y);
        byteBuf.writeDouble(this.z);
        byteBuf.writeResourceLocation(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)this.type));
    }

    public void onExecute(IPayloadContext ctxIn, Player player) {
        this.spawnParticles(this.type, player.level(), this.x, this.y, this.z);
    }

    private void spawnParticles(SimpleParticleType particleType, Level world, double x, double y, double z) {
        Random rand = new Random();
        for (int i = 0; i < 5; ++i) {
            double d0 = rand.nextGaussian() * 0.02;
            double d1 = rand.nextGaussian() * 0.02;
            double d2 = rand.nextGaussian() * 0.02;
            world.addParticle((ParticleOptions)particleType, x + (double)rand.nextFloat() * 0.6 * 2.0 - 0.6, y + 1.0 + (double)rand.nextFloat() * 1.8, z + (double)rand.nextFloat() * 0.6 * 2.0 - 0.6, d0, d1, d2);
        }
    }
}

