/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.util.Log;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyVisitorViewDataMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_visitor_view_data", ColonyVisitorViewDataMessage::new);
    private final int colonyId;
    private final ResourceKey<Level> dimension;
    private Set<IVisitorData> visitors;
    private final RegistryFriendlyByteBuf visitorBuf;
    private final boolean refresh;

    public ColonyVisitorViewDataMessage(@NotNull IColony colony, @NotNull Set<IVisitorData> visitors, boolean refresh) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.dimension = colony.getDimension();
        this.visitors = visitors;
        this.refresh = refresh;
        this.visitorBuf = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), colony.getWorld().registryAccess());
        this.visitorBuf.writeInt(visitors.size());
        for (IVisitorData data : visitors) {
            this.visitorBuf.writeInt(data.getId());
            data.serializeViewNetworkData(this.visitorBuf);
        }
    }

    public ColonyVisitorViewDataMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.refresh = buf.readBoolean();
        this.visitorBuf = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        this.visitorBuf.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeBoolean(this.refresh);
        buf.writeByteArray(this.visitorBuf.array());
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyView colony = IColonyManager.getInstance().getColonyView(this.colonyId, this.dimension);
        if (colony == null) {
            Log.getLogger().warn("Received visitor data for nonexisting colony:" + this.colonyId + " dim:" + String.valueOf(this.dimension));
        } else {
            colony.handleColonyViewVisitorMessage(this.visitorBuf, this.refresh);
        }
    }
}

