/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.fields.registry.FieldRegistries;
import com.minecolonies.core.colony.fields.FarmField;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FarmFieldPlotResizeMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"farm_field_plot_resize", FarmFieldPlotResizeMessage::new);
    private final int size;
    private final Direction direction;
    private final BlockPos position;

    public FarmFieldPlotResizeMessage(IColony colony, int size, Direction direction, BlockPos position) {
        super(TYPE, colony);
        this.size = size;
        this.direction = direction;
        this.position = position;
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        colony.getBuildingManager().getField(f -> f.getFieldType().equals(FieldRegistries.farmField.get()) && f.getPosition().equals((Object)this.position)).map(m -> (FarmField)m).ifPresent(field -> field.setRadius(this.direction, this.size));
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.size);
        buf.writeInt(this.direction.get2DDataValue());
        buf.writeBlockPos(this.position);
    }

    protected FarmFieldPlotResizeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.size = buf.readInt();
        this.direction = Direction.from2DDataValue((int)buf.readInt());
        this.position = buf.readBlockPos();
    }
}

