/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers.main;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.storage.ISurvivalBlueprintHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.PlaceStructureTrigger;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.items.component.HutBlockData;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.CreativeBuildingStructureHandler;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.blocks.huts.BlockHutTownHall;
import com.minecolonies.core.entity.ai.workers.util.ConstructionTapeHelper;
import com.minecolonies.core.event.EventHandler;
import com.minecolonies.core.network.messages.client.OpenDecoBuildWindowMessage;
import com.minecolonies.core.network.messages.client.OpenPlantationFieldBuildWindowMessage;
import com.minecolonies.core.util.AdvancementUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class SurvivalHandler
implements ISurvivalBlueprintHandler {
    public String getId() {
        return "minecolonies";
    }

    public Component getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.blueprint.placement", (Object[])new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canHandle(Blueprint blueprint, ClientLevel clientLevel, Player player, BlockPos blockPos, RotationMirror rotMir) {
        if (((Boolean)((ServerConfiguration)IMinecoloniesAPI.getInstance().getConfig().getServer()).blueprintBuildMode.get()).booleanValue()) {
            IColonyView colonyView = IColonyManager.getInstance().getClosestColonyView((Level)clientLevel, blockPos);
            return colonyView != null;
        }
        return true;
    }

    public void handle(Blueprint blueprint, String packName, String blueprintPath, boolean clientPack, Level world, Player player, BlockPos blockPos, RotationMirror rotMir) {
        boolean isInColony;
        if (blueprint == null) {
            MessageUtils.format("com.minecolonies.coremod.structures.nocustomhuts", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.blockPosition());
            return;
        }
        blueprint.setRotationMirror(rotMir, world);
        BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
        IColony tempColony = IColonyManager.getInstance().getClosestColony(world, blockPos);
        boolean bl = isInColony = tempColony != null && tempColony.isCoordInColony(world, blockPos);
        if (isInColony && !tempColony.getPermissions().hasPermission(player, Action.MANAGE_HUTS)) {
            MessageUtils.format("com.minecolonies.coremod.placement.noperm", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.blockPosition());
            return;
        }
        boolean successfulTownHallLocation = false;
        if (anchor.getBlock() instanceof BlockHutTownHall) {
            if (isInColony || IColonyManager.getInstance().isFarEnoughFromColonies(world, blockPos)) {
                successfulTownHallLocation = true;
            } else {
                MessageUtils.format("com.minecolonies.coremod.placement.townhalltooclose", new Object[0]).sendTo(player);
                SoundUtils.playErrorSound(player, player.blockPosition());
                return;
            }
        }
        if (!(isInColony && this.isBlueprintInColony(blueprint, tempColony, blockPos) || successfulTownHallLocation)) {
            MessageUtils.format("com.minecolonies.coremod.placement.outofcolony", new Object[0]).sendTo(player);
            SoundUtils.playErrorSound(player, player.blockPosition());
            return;
        }
        if (anchor.is(ModBlocks.blockPlantationField)) {
            new OpenPlantationFieldBuildWindowMessage(blockPos, packName, blueprintPath, rotMir).sendToPlayer((ServerPlayer)player);
        }
        if (anchor.getBlock() instanceof AbstractBlockHut) {
            if (clientPack || !StructurePacks.hasPack((String)packName) || blueprintPath.startsWith("scans/")) {
                MessageUtils.format("com.minecolonies.coremod.structures.buildingmissing", new Object[0]).sendTo(player);
                SoundUtils.playErrorSound(player, player.blockPosition());
                return;
            }
            ItemStack stack = new ItemStack((ItemLike)anchor.getBlock());
            if (EventHandler.onBlockHutPlaced(world, player, anchor.getBlock(), blockPos)) {
                int slot = InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)new InvWrapper((Container)player.getInventory()), anchor.getBlock());
                if (slot == -1 && !player.isCreative()) {
                    SoundUtils.playErrorSound(player, player.blockPosition());
                    return;
                }
                ItemStack inventoryStack = slot == -1 ? stack : player.getInventory().getItem(slot);
                ColonyId colonyComponent = ColonyId.readFromItemStack(stack);
                if (colonyComponent.hasColonyId() && tempColony != null && tempColony.getID() != colonyComponent.id()) {
                    MessageUtils.format("com.minecolonies.coremod.gui.buildtool.wrongcolony", colonyComponent.id()).sendTo(player);
                    SoundUtils.playErrorSound(player, player.blockPosition());
                    return;
                }
                world.destroyBlock(blockPos, true);
                world.setBlockAndUpdate(blockPos, anchor);
                ((AbstractBlockHut)anchor.getBlock()).onBlockPlacedByBuildTool(world, blockPos, anchor, (LivingEntity)player, null, rotMir, packName, blueprintPath);
                try {
                    NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)world.dimension(), (LevelAccessor)world, (BlockPos)blockPos), world.getBlockState(blockPos.below()), (Entity)player));
                }
                catch (Exception e) {
                    Log.getLogger().error("Error during EntityPlaceEvent", (Throwable)e);
                }
                if (tempColony == null) {
                    SoundUtils.playSuccessSound(player, player.blockPosition());
                    InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), inventoryStack, 1);
                    return;
                }
                AdvancementUtils.TriggerAdvancementPlayersForColony(tempColony, playerMP -> ((PlaceStructureTrigger)((Object)((Object)AdvancementTriggers.PLACE_STRUCTURE.get()))).trigger((ServerPlayer)playerMP, ((AbstractBlockHut)anchor.getBlock()).getBlueprintName()));
                int level = 0;
                boolean finishedUpgrade = false;
                HutBlockData hutComponent = HutBlockData.readFromItemStack(inventoryStack);
                if (hutComponent != null) {
                    if (hutComponent.level() != -1) {
                        level = hutComponent.level();
                    }
                    if (hutComponent.pastable()) {
                        Object newBlueprintPath = blueprintPath;
                        newBlueprintPath = ((String)newBlueprintPath).substring(0, ((String)newBlueprintPath).length() - 1);
                        newBlueprintPath = (String)newBlueprintPath + level;
                        CreativeBuildingStructureHandler.loadAndPlaceStructureWithRotation(player.level(), StructurePacks.getBlueprintFuture((String)packName, (String)newBlueprintPath, (HolderLookup.Provider)world.registryAccess()), blockPos, rotMir, true, (ServerPlayer)player);
                        finishedUpgrade = true;
                    }
                }
                InventoryUtils.reduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), inventoryStack, 1);
                @Nullable IBuilding building = IColonyManager.getInstance().getBuilding(world, blockPos);
                if (building == null) {
                    if (!(anchor.getBlock() instanceof BlockHutTownHall)) {
                        SoundUtils.playErrorSound(player, player.blockPosition());
                        Log.getLogger().error("BuildTool: building is null!", (Throwable)new Exception());
                        return;
                    }
                } else {
                    if (building.getTileEntity() != null) {
                        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(world, blockPos);
                        if (colony == null) {
                            Log.getLogger().info("No colony for " + player.getName().getString());
                        } else {
                            building.getTileEntity().setColony(colony);
                        }
                    }
                    building.setStructurePack(packName);
                    building.setBlueprintPath(blueprintPath);
                    building.setBuildingLevel(level);
                    if (level > 0) {
                        building.setDeconstructed();
                    }
                    if (!(building instanceof IRSComponent)) {
                        ConstructionTapeHelper.placeConstructionTape(building.getCorners(), building.getColony());
                    }
                    building.setRotationMirror(rotMir);
                    if (finishedUpgrade) {
                        building.onUpgradeComplete(building.getBuildingLevel());
                    }
                }
            }
            SoundUtils.playSuccessSound(player, player.blockPosition());
        } else if (blueprint.getBlockState(blueprint.getPrimaryBlockOffset()).getBlock() instanceof ILeveledBlueprintAnchorBlock) {
            int level = Utils.getBlueprintLevel(blueprint.getFileName());
            if (level == -1) {
                new OpenDecoBuildWindowMessage(blockPos, packName, blueprintPath, rotMir).sendToPlayer((ServerPlayer)player);
            } else {
                new OpenDecoBuildWindowMessage(blockPos, packName, blueprintPath.replace(level + ".blueprint", "1.blueprint"), rotMir).sendToPlayer((ServerPlayer)player);
            }
        } else {
            new OpenDecoBuildWindowMessage(blockPos, packName, blueprintPath, rotMir).sendToPlayer((ServerPlayer)player);
        }
        Log.getLogger().warn("Handling Survival Placement in Colony");
    }

    private boolean isBlueprintInColony(Blueprint blueprint, IColony colony, BlockPos blockPos) {
        Level world = colony.getWorld();
        BlockPos zeroPos = blockPos.subtract((Vec3i)blueprint.getPrimaryBlockOffset());
        BlockPos pos1 = new BlockPos(zeroPos.getX(), zeroPos.getY(), zeroPos.getZ());
        BlockPos pos2 = new BlockPos(zeroPos.getX() + blueprint.getSizeX() - 1, zeroPos.getY() + blueprint.getSizeY() - 1, zeroPos.getZ() + blueprint.getSizeZ() - 1);
        int minX = Math.min(pos1.getX(), pos2.getX()) + 1;
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int minZ = Math.min(pos1.getZ(), pos2.getZ()) + 1;
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        for (int x = minX; x < maxX; x += 16) {
            for (int z = minZ; z < maxZ; z += 16) {
                int chunkX = x >> 4;
                int chunkZ = z >> 4;
                ChunkPos pos = new ChunkPos(chunkX, chunkZ);
                if (ColonyUtils.getOwningColony((ChunkAccess)world.getChunk(pos.x, pos.z)) == colony.getID()) continue;
                return false;
            }
        }
        return true;
    }
}

