/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class ResearchEffectCategory {
    public static final String RESEARCH_EFFECT_PROP = "effect";
    public static final String RESEARCH_EFFECT_LEVELS_PROP = "levels";
    private final ResourceLocation effectId;
    private final TranslatableContents effectName;
    private final TranslatableContents subtitle;
    private final List<Double> levelsAbsolute = new ArrayList<Double>();
    private final List<Double> levelsRelative = new ArrayList<Double>();

    public ResearchEffectCategory(String effectId, String effectName, String subtitle) {
        this.effectId = ResourceLocation.parse((String)effectId);
        this.effectName = effectName != null ? new TranslatableContents(effectName, null, TranslatableContents.NO_ARGS) : new TranslatableContents("com." + this.effectId.getNamespace() + ".research." + this.effectId.getPath().replaceAll("[ /]", ".") + ".description", null, TranslatableContents.NO_ARGS);
        this.subtitle = new TranslatableContents(subtitle, null, TranslatableContents.NO_ARGS);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public ResearchEffectCategory(String effectId, String effectName) {
        this.effectId = ResourceLocation.parse((String)effectId);
        this.effectName = new TranslatableContents(effectName, null, TranslatableContents.NO_ARGS);
        this.subtitle = new TranslatableContents("", null, TranslatableContents.NO_ARGS);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public ResearchEffectCategory(String effectId) {
        this.effectId = ResourceLocation.parse((String)effectId);
        this.effectName = new TranslatableContents("com." + this.effectId.getNamespace() + ".research." + this.effectId.getPath().replaceAll("[ /]", ".") + ".description", null, TranslatableContents.NO_ARGS);
        this.subtitle = new TranslatableContents("", null, TranslatableContents.NO_ARGS);
        this.levelsAbsolute.add(0.0);
        this.levelsRelative.add(0.0);
    }

    public void add(double newVal) {
        this.levelsRelative.add(newVal - this.levelsAbsolute.get(this.levelsAbsolute.size() - 1));
        this.levelsAbsolute.add(newVal);
    }

    public double getDisplay(int level) {
        return this.levelsRelative.get(level);
    }

    public double get(int level) {
        return this.levelsAbsolute.get(level);
    }

    public int getMaxLevel() {
        return this.levelsAbsolute.size() - 1;
    }

    public ResourceLocation getId() {
        return this.effectId;
    }

    public TranslatableContents getName() {
        return this.effectName;
    }

    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }
}

