/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.PlaceStructureOperation;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlockInfo;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import com.minecolonies.api.colony.colonyEvents.IColonyRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreativeRaiderStructureHandler
extends CreativeStructureHandler {
    private Map<BlockPos, List<String>> map;
    private IColonyRaidEvent event;
    private int colonyId;

    public CreativeRaiderStructureHandler(Level world, BlockPos pos, Future<Blueprint> blueprintFuture, RotationMirror rotMir, boolean fancyPlacement, IColonyRaidEvent event, int colonyId) {
        super(world, pos, blueprintFuture, rotMir, fancyPlacement);
        BlockEntity entity;
        CompoundTag teData;
        this.event = event;
        this.colonyId = colonyId;
        BlockInfo info = this.getBluePrint().getBlockInfoAsMap().getOrDefault(this.getBluePrint().getPrimaryBlockOffset(), null);
        if (info.getTileEntityData() != null && (teData = this.getBluePrint().getTileEntityData(pos, this.getBluePrint().getPrimaryBlockOffset())) != null && teData.contains("blueprintDataProvider") && (entity = BlockEntity.loadStatic((BlockPos)pos, (BlockState)info.getState(), (CompoundTag)info.getTileEntityData(), (HolderLookup.Provider)world.registryAccess())) instanceof IBlueprintDataProviderBE) {
            this.map = ((IBlueprintDataProviderBE)entity).getWorldTagPosMap();
        }
        if (this.map == null) {
            Log.getLogger().error("Raider spawned without matching blueprint data for it: " + String.valueOf(blueprintFuture));
        }
    }

    public CreativeRaiderStructureHandler(Level world, BlockPos pos, Blueprint blueprint, RotationMirror rotMir, boolean fancyPlacement, IColonyRaidEvent event, int colonyId) {
        super(world, pos, blueprint, rotMir, fancyPlacement);
        BlockEntity entity;
        CompoundTag teData;
        this.event = event;
        this.colonyId = colonyId;
        BlockInfo info = this.getBluePrint().getBlockInfoAsMap().getOrDefault(this.getBluePrint().getPrimaryBlockOffset(), null);
        if (info.getTileEntityData() != null && (teData = this.getBluePrint().getTileEntityData(pos, this.getBluePrint().getPrimaryBlockOffset())) != null && teData.contains("blueprintDataProvider") && (entity = BlockEntity.loadStatic((BlockPos)pos, (BlockState)info.getState(), (CompoundTag)info.getTileEntityData(), (HolderLookup.Provider)world.registryAccess())) instanceof IBlueprintDataProviderBE) {
            this.map = ((IBlueprintDataProviderBE)entity).getWorldTagPosMap();
        }
        if (this.map == null) {
            Log.getLogger().error("Raider spawned without matching blueprint data for it: " + String.valueOf(blueprint));
        }
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        super.triggerSuccess(pos, list, placement);
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        if (this.getWorld().getBlockState(worldPos).getBlock() == Blocks.GOLD_BLOCK && this.map != null) {
            List tags = this.map.getOrDefault(worldPos, Collections.emptyList());
            Iterator iterator = tags.iterator();
            while (iterator.hasNext()) {
                String tag;
                switch (tag = (String)iterator.next()) {
                    case "normal": {
                        ShipBasedRaiderUtils.setupSpawner(worldPos, this.getWorld(), this.event.getNormalRaiderType(), this.event, this.colonyId);
                        return;
                    }
                    case "archer": {
                        ShipBasedRaiderUtils.setupSpawner(worldPos, this.getWorld(), this.event.getArcherRaiderType(), this.event, this.colonyId);
                        return;
                    }
                    case "boss": {
                        ShipBasedRaiderUtils.setupSpawner(worldPos, this.getWorld(), this.event.getBossRaiderType(), this.event, this.colonyId);
                        return;
                    }
                }
            }
        }
    }

    public static void loadAndPlaceStructure(Level worldObj, @NotNull Future<Blueprint> blueprintFuture, @NotNull BlockPos pos, boolean fancyPlacement, int colonyId, IColonyRaidEvent event, @Nullable ServerPlayer player) {
        try {
            @NotNull CreativeRaiderStructureHandler structure = new CreativeRaiderStructureHandler(worldObj, pos, blueprintFuture, RotationMirror.NONE, fancyPlacement, event, colonyId);
            Manager.addToQueue((ITickedWorldOperation)new PlaceStructureOperation(new StructurePlacer((IStructureHandler)structure), (Player)player));
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }

    public static void loadAndPlaceStructure(Level worldObj, @NotNull Blueprint blueprint, @NotNull BlockPos pos, boolean fancyPlacement, int colonyId, IColonyRaidEvent event, @Nullable ServerPlayer player) {
        try {
            @NotNull CreativeRaiderStructureHandler structure = new CreativeRaiderStructureHandler(worldObj, pos, blueprint, RotationMirror.NONE, fancyPlacement, event, colonyId);
            Manager.addToQueue((ITickedWorldOperation)new PlaceStructureOperation(new StructurePlacer((IStructureHandler)structure), (Player)player));
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
        }
    }
}

