/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.util.BlockInfo;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingFlorist;
import com.minecolonies.core.entity.ai.workers.util.MinerLevel;
import com.minecolonies.core.tileentities.TileEntityCompostedDirt;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.IShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorkerUtil {
    private static final double MIDDLE_BLOCK_OFFSET = 0.5;
    private static final String LEVEL_SIGN_TEXT = "level_placeholder";
    public static List<Tuple<EquipmentTypeEntry, ItemStack>> tools;

    private WorkerUtil() {
    }

    public static List<Tuple<EquipmentTypeEntry, ItemStack>> getOrInitTestTools() {
        if (tools == null) {
            tools = new ArrayList<Tuple<EquipmentTypeEntry, ItemStack>>();
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), new ItemStack((ItemLike)Items.NETHERITE_HOE)));
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), new ItemStack((ItemLike)Items.NETHERITE_SHOVEL)));
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.axe.get(), new ItemStack((ItemLike)Items.NETHERITE_AXE)));
            tools.add(new Tuple<EquipmentTypeEntry, ItemStack>((EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), new ItemStack((ItemLike)Items.NETHERITE_PICKAXE)));
        }
        return tools;
    }

    public static boolean isPathBlock(Block block) {
        return block.defaultBlockState().is(ModTags.pathingBlocks);
    }

    public static boolean setSpawnPoint(@Nullable BlockPos spawnPoint, @NotNull AbstractEntityCitizen citizen) {
        if (spawnPoint == null) {
            return false;
        }
        citizen.moveTo((double)spawnPoint.getX() + 0.5, spawnPoint.getY(), (double)spawnPoint.getZ() + 0.5, citizen.getRotationYaw(), citizen.getRotationPitch());
        citizen.getNavigation().stop();
        return true;
    }

    public static EquipmentTypeEntry getBestToolForBlock(BlockState state, float blockHardness, AbstractBuilding building, BlockGetter level, BlockPos pos) {
        if (state.getBlock() instanceof IShearable && building.hasModule((Class<? extends IBuildingModule>)SettingsModule.class) && ((SettingsModule)building.getFirstModuleOccurance(SettingsModule.class)).getSettingValueOrDefault(AbstractBuilding.USE_SHEARS, true).booleanValue()) {
            return (EquipmentTypeEntry)ModEquipmentTypes.shears.get();
        }
        if (blockHardness > 0.0f) {
            for (Tuple<EquipmentTypeEntry, ItemStack> tool : WorkerUtil.getOrInitTestTools()) {
                IMateriallyTexturedBlock materiallyTexturedBlock;
                if (tool.getB() == null || !(tool.getB().getItem() instanceof DiggerItem)) continue;
                Block block = state.getBlock();
                if (block instanceof IMateriallyTexturedBlock && (materiallyTexturedBlock = (IMateriallyTexturedBlock)block).isCorrectToolForDrops(state, tool.getB(), level, pos)) {
                    return tool.getA();
                }
                if (!tool.getB().isCorrectToolForDrops(state)) continue;
                return tool.getA();
            }
        }
        return (EquipmentTypeEntry)ModEquipmentTypes.none.get();
    }

    public static int getCorrectHarvestLevelForBlock(BlockState target) {
        int required = 0;
        for (Tiers tier : Tiers.values()) {
            TagKey tag = tier.getIncorrectBlocksForDrops();
            if (!target.is(tag)) continue;
            required = tier.ordinal();
            break;
        }
        if (target.getBlock() instanceof GlazedTerracottaBlock) {
            return 0;
        }
        return required;
    }

    public static void faceBlock(@Nullable BlockPos block, AbstractEntityCitizen citizen) {
        if (block == null) {
            return;
        }
        double xDifference = block.getX() - citizen.blockPosition().getX();
        double zDifference = block.getZ() - citizen.blockPosition().getZ();
        double yDifference = (float)block.getY() - ((float)citizen.blockPosition().getY() + citizen.getEyeHeight());
        double squareDifference = Math.sqrt(xDifference * xDifference + zDifference * zDifference);
        double intendedRotationYaw = Math.atan2(zDifference, xDifference) * 180.0 / Math.PI - 90.0;
        double intendedRotationPitch = -(Math.atan2(yDifference, squareDifference) * 180.0 / Math.PI);
        citizen.setOwnRotation((float)EntityUtils.updateRotation(citizen.getRotationYaw(), intendedRotationYaw, 30.0), (float)EntityUtils.updateRotation(citizen.getRotationPitch(), intendedRotationPitch, 30.0));
        double goToX = xDifference > 0.0 ? 0.001 : -0.001;
        double goToZ = zDifference > 0.0 ? 0.001 : -0.001;
        citizen.move(MoverType.SELF, new Vec3((double)((float)goToX), 0.0, (double)((float)goToZ)));
    }

    @Nullable
    public static BlockPos findFirstLevelSign(Blueprint structure, BlockPos pos, Level level) {
        for (int j = 0; j < structure.getSizeY(); ++j) {
            for (int k = 0; k < structure.getSizeZ(); ++k) {
                for (int i = 0; i < structure.getSizeX(); ++i) {
                    SignBlockEntity sign;
                    BlockEntity blockEntity;
                    BlockEntityType teType;
                    @NotNull BlockPos localPos = new BlockPos(i, j, k);
                    BlockInfo te = (BlockInfo)structure.getBlockInfoAsMap().get(localPos);
                    if (te == null) continue;
                    CompoundTag teData = te.getTileEntityData();
                    ResourceLocation teId = teData == null ? null : ResourceLocation.tryParse((String)teData.getString("id"));
                    BlockEntityType blockEntityType = teType = teId == null ? null : (BlockEntityType)BuiltInRegistries.BLOCK_ENTITY_TYPE.get(teId);
                    if (teType != BlockEntityType.SIGN && teType != BlockEntityType.HANGING_SIGN || !((blockEntity = BlockEntity.loadStatic((BlockPos)te.getPos(), (BlockState)te.getState(), (CompoundTag)te.getTileEntityData(), (HolderLookup.Provider)level.registryAccess())) instanceof SignBlockEntity) || !(sign = (SignBlockEntity)blockEntity).getFrontText().getMessage(0, false).getString().equals(LEVEL_SIGN_TEXT)) continue;
                    return pos.subtract((Vec3i)structure.getPrimaryBlockOffset()).offset((Vec3i)localPos);
                }
            }
        }
        return null;
    }

    public static void updateLevelSign(Level world, MinerLevel level, int levelId) {
        BlockEntity blockEntity;
        @Nullable BlockPos levelSignPos = level.getLevelSign();
        if (levelSignPos != null && (blockEntity = world.getBlockEntity(levelSignPos)) instanceof SignBlockEntity) {
            SignBlockEntity teLevelSign = (SignBlockEntity)blockEntity;
            BlockState blockState = world.getBlockState(levelSignPos);
            SignText text = new SignText().setMessage(0, (Component)Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.minerminenode", (Object[])new Object[0]).append(": " + levelId)).setMessage(1, (Component)Component.literal((String)("Y: " + (level.getDepth() + 1)))).setMessage(2, (Component)Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.minernode", (Object[])new Object[0]).append(": " + level.getNumberOfBuiltNodes())).setMessage(3, (Component)Component.literal((String)""));
            teLevelSign.setText(text, true);
            teLevelSign.setText(text, false);
            teLevelSign.setChanged();
            world.sendBlockUpdated(levelSignPos, blockState, blockState, 3);
        }
    }

    public static boolean isThereCompostedLand(BuildingFlorist buildingFlorist, Level world) {
        for (BlockPos pos : buildingFlorist.getPlantGround()) {
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockEntity entity = world.getBlockEntity(pos);
            if (entity instanceof TileEntityCompostedDirt) {
                if (!((TileEntityCompostedDirt)entity).isComposted()) continue;
                return true;
            }
            buildingFlorist.removePlantableGround(pos);
        }
        return false;
    }

    public static int getLastLadder(@NotNull BlockPos pos, Level world) {
        if (world.getBlockState(pos).getBlock().isLadder(world.getBlockState(pos), (LevelReader)world, pos, null)) {
            return WorkerUtil.getLastLadder(pos.below(), world);
        }
        return pos.getY() + 1;
    }

    public static boolean hasTooManyExternalItemsInInv(IRecipeStorage currentRecipeStorage, @NotNull InventoryCitizen inv) {
        int count = 0;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.isEmpty() || WorkerUtil.isPartOfRecipe(stack, currentRecipeStorage) || ++count <= 3) continue;
            return true;
        }
        return false;
    }

    public static boolean isPartOfRecipe(ItemStack stack, IRecipeStorage currentRecipeStorage) {
        if (ItemStackUtils.compareItemStacksIgnoreStackSize(stack, currentRecipeStorage.getPrimaryOutput()).booleanValue()) {
            return true;
        }
        for (ItemStack itemStack : currentRecipeStorage.getCraftingToolsAndSecondaryOutputs()) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack, stack).booleanValue()) continue;
            return true;
        }
        for (ItemStorage itemStorage : currentRecipeStorage.getCleanedInput()) {
            if (!itemStorage.equals(new ItemStorage(stack))) continue;
            return true;
        }
        return false;
    }
}

