/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.prism.util;

import com.anthonyhilyard.prism.text.DynamicColor;
import com.anthonyhilyard.prism.util.IColor;
import com.anthonyhilyard.prism.util.MinecraftColors;
import com.anthonyhilyard.prism.util.WebColors;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.network.chat.TextColor;

public class ConfigHelper {
    public static List<ColorFormatDocumentation> colorFormatDocumentation() {
        return ConfigHelper.colorFormatDocumentation(false);
    }

    public static List<ColorFormatDocumentation> colorFormatDocumentation(boolean forKey) {
        if (!forKey) {
            return Arrays.asList(new ColorFormatDocumentation("Hex color code", "A hex color code is preceded by # or 0x and must be quoted.  Supports 3, 4, 6, or 8 digit codes in the formats RGB, ARGB, RRGGBB, AARRGGBB.", "\"#F4C\"", "\"0xFEE0\"", "\"#40FF2E\"", "\"#CC00E2EE\""), new ColorFormatDocumentation("Decimal color code", "A decimal color code, which is just a hex color code converted to decimal.  May or may not be quoted.", "15614720", "\"4278251143\""), new ColorFormatDocumentation("Minecraft color name", "One of the standard 16 Minecraft color names.  Must be quoted.", "\"red\"", "\"dark_purple\"", "\"gold\""), new ColorFormatDocumentation("Web color name", "One of the standard 140 web/HTML color names or \"transparent\".  Must be quoted.", "\"chartreuse\"", "\"darkorange\"", "\"deeppink\"", "\"deepskyblue\""), new ColorFormatDocumentation("Modifiers", "Colors specified in any of the above formats can be modified by using modifiers.\nModifiers are specified after any color in the format \"<+, -, or =><h, s, v, r, g, b, or a><amount>\".\nThe letters represent h - hue, s - saturation, v - value, r - red, g - green, b - blue, a - alpha.\nValid amounts are 0 to 255 for all types except hue, which accepts 0 to 359.", "\"red+h15\"", "\"#saddlebrown-v20+s5\"", "\"10_aqua_aqua+v15-h5\"", "\"#F4C-r15-v10=a40\""), new ColorFormatDocumentation("Animated color", "An animated color that fades from one to another in sequence.\nA string in the format \"<duration in seconds>_<list of color definitions separated by underscores>\".  Must be quoted.", "\"10_black_#7FFF00\"", "\"5.5_gold_orange_orangered\"", "\"20_red_orange_yellow_green_blue_purple\""));
        }
        return Arrays.asList(new ColorFormatDocumentation("Hex color code", "A hex color code is preceded by # or 0x and must be quoted.  Supports 3, 4, 6, or 8 digit codes in the formats RGB, ARGB, RRGGBB, or AARRGGBB.", "\"#F4C\"", "\"0xFEE0\"", "\"#40FF2E\"", "\"#CC00E2EE\""), new ColorFormatDocumentation("Decimal color code", "A decimal color code, which is just a hex color code converted to decimal.  May or may not be quoted.", "15614720", "\"4278251143\""), new ColorFormatDocumentation("Minecraft color name", "One of the standard 16 Minecraft color names.  May or may not be quoted.", "\"red\"", "\"dark_purple\"", "\"gold\""), new ColorFormatDocumentation("Web color name", "One of the standard 140 web/HTML color names or \"transparent\".  May or may not be quoted.", "\"chartreuse\"", "\"darkorange\"", "\"deeppink\"", "\"deepskyblue\""), new ColorFormatDocumentation("Modifiers", "Colors specified in any of the above formats can be modified by using modifiers.\nModifiers are specified after any color in the format \"<+, -, or =><h, s, v, r, g, b, or a><amount>\".\nThe letters represent h - hue, s - saturation, v - value, r - red, g - green, b - blue, a - alpha.\nValid amounts are 0 to 255 for all types except hue, which accepts 0 to 359.\nUsing any modifiers will REQUIRE the key to be quoted.\n", "\"red+h15\"", "\"#saddlebrown-v20+s5\"", "\"10_aqua_aqua+v15-h5\"", "\"#F4C-r15-v10=a40\""), new ColorFormatDocumentation("Animated color", "An animated color that fades from one to another in sequence.\nA string in the format \"<duration in seconds>_<list of color definitions separated by underscores>\".  May or may not be quoted.", "\"10_black_#7FFF00\"", "\"5.5_gold_orange_orangered\"", "\"20_red_orange_yellow_green_blue_purple\""));
    }

    public static TextColor applyModifiers(List<String> modifiers, TextColor color) {
        return TextColor.fromRgb((int)ConfigHelper.applyModifiers(modifiers, DynamicColor.fromRgb(color.getValue())).getValue());
    }

    public static DynamicColor applyModifiers(List<String> modifiers, DynamicColor color) {
        Map<Character, BiFunction<Integer, Integer, Integer>> modifierFuncs = Map.of(Character.valueOf('+'), (v, a) -> v + a, Character.valueOf('-'), (v, a) -> v - a, Character.valueOf('='), (v, a) -> a);
        block11: for (String modifier : modifiers) {
            BiFunction<Integer, Integer, Integer> mod;
            int amount;
            if (modifier.length() < 3) continue;
            char type = modifier.toLowerCase().charAt(1);
            try {
                amount = Integer.parseInt(modifier.substring(2));
                mod = modifierFuncs.get(Character.valueOf(modifier.charAt(0)));
            }
            catch (Exception e) {
                continue;
            }
            if (mod == null) continue;
            switch (type) {
                case 'h': {
                    color = DynamicColor.fromAHSV(color.alpha(), mod.apply(color.hue(), amount), color.saturation(), color.value());
                    continue block11;
                }
                case 's': {
                    color = DynamicColor.fromAHSV(color.alpha(), color.hue(), mod.apply(color.saturation(), amount), color.value());
                    continue block11;
                }
                case 'v': {
                    color = DynamicColor.fromAHSV(color.alpha(), color.hue(), color.saturation(), mod.apply(color.value(), amount));
                    continue block11;
                }
                case 'r': {
                    color = DynamicColor.fromARGB(color.alpha(), mod.apply(color.red(), amount), color.green(), color.blue());
                    continue block11;
                }
                case 'g': {
                    color = DynamicColor.fromARGB(color.alpha(), color.red(), mod.apply(color.green(), amount), color.blue());
                    continue block11;
                }
                case 'b': {
                    color = DynamicColor.fromARGB(color.alpha(), color.red(), color.green(), mod.apply(color.blue(), amount));
                    continue block11;
                }
                case 'a': {
                    color = DynamicColor.fromARGB(mod.apply(color.alpha(), amount), color.red(), color.green(), color.blue());
                    continue block11;
                }
            }
        }
        return color;
    }

    public static IColor parseColor(Object value, boolean allowAlpha) {
        List list;
        String string;
        List<Object> unparsedColors = null;
        ArrayList colors = Lists.newArrayList();
        float duration = 10.0f;
        if (value instanceof String && (string = (String)value).contains("_")) {
            entries = List.of(string.split("_"));
            try {
                duration = Float.parseFloat(entries.get(0));
                unparsedColors = entries.stream().skip(1L).map(s -> s).toList();
            }
            catch (NumberFormatException e) {
                unparsedColors = entries.stream().map(s -> s).toList();
            }
        } else if (value instanceof List && !(list = (List)value).isEmpty()) {
            entries = null;
            try {
                entries = Collections.unmodifiableList(list);
                String string2 = entries.get(0);
                if (string2 instanceof String) {
                    String string3 = string2;
                    duration = Float.parseFloat(string3);
                } else {
                    string2 = entries.get(0);
                    if (string2 instanceof Number) {
                        Number number = (Number)((Object)string2);
                        duration = number.floatValue();
                    }
                }
                unparsedColors = entries.subList(1, entries.size());
            }
            catch (NumberFormatException e) {
                unparsedColors = entries;
            }
            catch (ClassCastException e) {}
        } else {
            unparsedColors = Lists.newArrayList();
            unparsedColors.add(value);
        }
        if (unparsedColors == null || unparsedColors.isEmpty()) {
            return null;
        }
        for (Object unparsedValue : unparsedColors) {
            if (unparsedValue == null) {
                return null;
            }
            boolean isTransparent = false;
            TextColor color = null;
            ArrayList modifiers = List.of();
            if (unparsedValue instanceof String) {
                String string4 = (String)unparsedValue;
                if ((string4 = string4.replace("~", "").replace("-", "~-").replace("+", "~+")).contains("~") && (modifiers = Lists.newArrayList((Object[])string4.split("~"))).size() > 1) {
                    string4 = (String)modifiers.remove(0);
                }
                if (ConfigHelper.isValidColorCode(string4)) {
                    boolean isHex = string4.startsWith("0x") || string4.startsWith("#");
                    String colorString = string4.toLowerCase().replace("0x", "").replace("#", "");
                    if (isHex && colorString.length() == 3 || colorString.length() == 4) {
                        colorString = colorString.replaceAll(".", "$0$0");
                    }
                    color = TextColor.parseColor((String)("#" + colorString)).result().orElse(null);
                } else if (string4.toLowerCase().contentEquals("transparent")) {
                    isTransparent = true;
                    color = TextColor.fromRgb((int)0);
                } else {
                    color = MinecraftColors.getColor(string4);
                    if (color == null) {
                        color = (TextColor)WebColors.getColor(string4);
                    }
                }
            } else if (unparsedValue instanceof Number) {
                Number number = (Number)unparsedValue;
                color = TextColor.fromRgb((int)number.intValue());
            }
            if (color != null && !isTransparent && color.getValue() > 0 && color.getValue() <= 0xFFFFFF) {
                color = TextColor.fromRgb((int)(color.getValue() | 0xFF000000));
            }
            if (color != null) {
                color = ConfigHelper.applyModifiers(modifiers, color);
            }
            if (!allowAlpha && color.getValue() > 0xFFFFFF) {
                color = TextColor.fromRgb((int)(color.getValue() | 0xFF000000));
            }
            if (color == null) continue;
            colors.add((IColor)color);
        }
        if (colors.size() == 1) {
            return (IColor)colors.get(0);
        }
        if (colors.size() > 1) {
            return new DynamicColor(colors, duration);
        }
        return null;
    }

    public static IColor parseColor(Object value) {
        return ConfigHelper.parseColor(value, true);
    }

    public static boolean validateColor(Object value) {
        return ConfigHelper.parseColor(value) != null;
    }

    private static boolean isValidColorCode(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            String string = (String)value;
            if (string.isEmpty()) {
                return false;
            }
            boolean isHex = false;
            if (string.startsWith("0x") || string.startsWith("#")) {
                isHex = true;
                string = string.replace("0x", "").replace("#", "");
            }
            if (isHex) {
                try {
                    Long number = Long.parseUnsignedLong(string, 16);
                    if (Long.compareUnsigned(number, 0L) < 0 || Long.compareUnsigned(number, -1L) > 0) {
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return string.length() == 3 || string.length() == 4 || string.length() == 6 || string.length() == 8;
            }
            try {
                long number = Long.parseUnsignedLong(string);
                if (Long.compareUnsigned(number, 0L) < 0 || Long.compareUnsigned(number, -1L) > 0) {
                    return false;
                }
            }
            catch (NumberFormatException e) {
                return false;
            }
            return string.length() <= 10;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            Long colorValue = number.longValue();
            return Long.compareUnsigned(colorValue, 0L) >= 0 && Long.compareUnsigned(colorValue, -1L) <= 0;
        }
        return false;
    }

    static String formatColorName(String input) {
        return input.toLowerCase().replace(" ", "").replace("_", "");
    }

    public record ColorFormatDocumentation(String name, String description, List<String> examples) {
        public ColorFormatDocumentation(String name, String description, String ... examples) {
            this(name, description, Arrays.asList(examples));
        }
    }
}

