/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier;

import com.yungnickyoung.minecraft.yungsapi.mixin.accessor.BeardifierAccessor;
import com.yungnickyoung.minecraft.yungsapi.world.structure.YungJigsawStructure;
import com.yungnickyoung.minecraft.yungsapi.world.structure.jigsaw.element.YungJigsawPoolElement;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.EnhancedTerrainAdaptation;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierData;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedBeardifierRigid;
import com.yungnickyoung.minecraft.yungsapi.world.structure.terrainadaptation.beardifier.EnhancedJigsawJunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.JigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class EnhancedBeardifierHelper {
    public static Beardifier forStructuresInChunk(StructureManager structureManager, ChunkPos chunkPos, Beardifier original) {
        ObjectArrayList enhancedBeardifierRigidList = new ObjectArrayList(10);
        ObjectArrayList enhancedJunctionList = new ObjectArrayList(10);
        int chunkMinBlockX = chunkPos.getMinBlockX();
        int chunkMinBlockZ = chunkPos.getMinBlockZ();
        List structureStarts = structureManager.startsForStructure(chunkPos, structure -> structure instanceof YungJigsawStructure);
        for (StructureStart structureStart : structureStarts) {
            EnhancedTerrainAdaptation structureTerrainAdaptation = ((YungJigsawStructure)structureStart.getStructure()).enhancedTerrainAdaptation;
            int kernelRadius = structureTerrainAdaptation.getKernelRadius();
            for (StructurePiece structurePiece2 : structureStart.getPieces()) {
                YungJigsawPoolElement yungElement;
                PoolElementStructurePiece poolPiece;
                StructurePoolElement structurePoolElement;
                if (!(structurePiece2 instanceof PoolElementStructurePiece) || !((structurePoolElement = (poolPiece = (PoolElementStructurePiece)structurePiece2).getElement()) instanceof YungJigsawPoolElement) || !(yungElement = (YungJigsawPoolElement)structurePoolElement).getEnhancedTerrainAdaptation().isPresent()) continue;
                kernelRadius = Math.max(kernelRadius, yungElement.getEnhancedTerrainAdaptation().get().getKernelRadius());
            }
            int maxKernelRadius = kernelRadius;
            if (maxKernelRadius <= 0) continue;
            List<StructurePiece> nearbyPieces = structureStart.getPieces().stream().filter(structurePiece -> structurePiece.isCloseToChunk(chunkPos, maxKernelRadius)).toList();
            for (StructurePiece nearbyPiece : nearbyPieces) {
                if (nearbyPiece instanceof PoolElementStructurePiece) {
                    YungJigsawPoolElement yungElement;
                    PoolElementStructurePiece poolElementPiece = (PoolElementStructurePiece)nearbyPiece;
                    StructureTemplatePool.Projection projection = poolElementPiece.getElement().getProjection();
                    EnhancedTerrainAdaptation pieceTerrainAdaptation = structureTerrainAdaptation;
                    StructurePoolElement structurePoolElement = poolElementPiece.getElement();
                    if (structurePoolElement instanceof YungJigsawPoolElement && (yungElement = (YungJigsawPoolElement)structurePoolElement).getEnhancedTerrainAdaptation().isPresent()) {
                        pieceTerrainAdaptation = yungElement.getEnhancedTerrainAdaptation().get();
                    }
                    if (pieceTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                    int pieceKernelRadius = pieceTerrainAdaptation.getKernelRadius();
                    if (projection == StructureTemplatePool.Projection.RIGID) {
                        enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(poolElementPiece.getBoundingBox(), pieceTerrainAdaptation, poolElementPiece.getGroundLevelDelta(), poolElementPiece.getRotation()));
                    }
                    for (JigsawJunction jigsawJunction : poolElementPiece.getJunctions()) {
                        int sourceX = jigsawJunction.getSourceX();
                        int sourceZ = jigsawJunction.getSourceZ();
                        if (sourceX <= chunkMinBlockX - pieceKernelRadius || sourceZ <= chunkMinBlockZ - pieceKernelRadius || sourceX >= chunkMinBlockX + 15 + pieceKernelRadius || sourceZ >= chunkMinBlockZ + 15 + pieceKernelRadius) continue;
                        enhancedJunctionList.add((Object)new EnhancedJigsawJunction(jigsawJunction, pieceTerrainAdaptation));
                    }
                    continue;
                }
                if (structureTerrainAdaptation == EnhancedTerrainAdaptation.NONE) continue;
                enhancedBeardifierRigidList.add((Object)new EnhancedBeardifierRigid(nearbyPiece.getBoundingBox(), structureTerrainAdaptation, 0, Rotation.NONE));
            }
        }
        Beardifier newBeardifier = new Beardifier(((BeardifierAccessor)original).getPieceIterator(), ((BeardifierAccessor)original).getJunctionIterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedPieceIterator((ObjectListIterator<EnhancedBeardifierRigid>)enhancedBeardifierRigidList.iterator());
        ((EnhancedBeardifierData)newBeardifier).setEnhancedJunctionIterator((ObjectListIterator<EnhancedJigsawJunction>)enhancedJunctionList.iterator());
        return newBeardifier;
    }

    public static double computeDensity(DensityFunction.FunctionContext ctx, double density, EnhancedBeardifierData data) {
        EnhancedTerrainAdaptation pieceTerrainAdaptation;
        int x = ctx.blockX();
        int y = ctx.blockY();
        int z = ctx.blockZ();
        while (data.getEnhancedPieceIterator() != null && data.getEnhancedPieceIterator().hasNext()) {
            EnhancedBeardifierRigid rigid = (EnhancedBeardifierRigid)data.getEnhancedPieceIterator().next();
            BoundingBox pieceBoundingBox = rigid.pieceBoundingBox();
            pieceTerrainAdaptation = rigid.pieceTerrainAdaptation();
            Rotation pieceRotation = rigid.rotation();
            pieceBoundingBox = pieceBoundingBox.moved(0, (int)pieceTerrainAdaptation.getBottomOffset(), 0);
            Direction.Axis xPaddingDirection = pieceRotation.rotate(Direction.EAST).getAxis();
            int xPadding = xPaddingDirection == Direction.Axis.X ? pieceTerrainAdaptation.getPadding().x() : pieceTerrainAdaptation.getPadding().z();
            int zPadding = xPaddingDirection == Direction.Axis.X ? pieceTerrainAdaptation.getPadding().z() : pieceTerrainAdaptation.getPadding().x();
            pieceBoundingBox = pieceBoundingBox.inflatedBy(xPadding, 0, zPadding);
            if (pieceTerrainAdaptation.getPadding().top() != 0) {
                pieceBoundingBox = new BoundingBox(pieceBoundingBox.minX(), pieceBoundingBox.minY(), pieceBoundingBox.minZ(), pieceBoundingBox.maxX(), pieceBoundingBox.maxY() + pieceTerrainAdaptation.getPadding().top(), pieceBoundingBox.maxZ());
            }
            if (pieceTerrainAdaptation.getPadding().bottom() != 0) {
                pieceBoundingBox = new BoundingBox(pieceBoundingBox.minX(), pieceBoundingBox.minY() - pieceTerrainAdaptation.getPadding().bottom(), pieceBoundingBox.minZ(), pieceBoundingBox.maxX(), pieceBoundingBox.maxY(), pieceBoundingBox.maxZ());
            }
            int xDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.minX() - x, x - pieceBoundingBox.maxX()));
            int yDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.minY() - y, y - pieceBoundingBox.maxY()));
            int zDistanceToBoundingBox = Math.max(0, Math.max(pieceBoundingBox.minZ() - z, z - pieceBoundingBox.maxZ()));
            int yDistanceToPieceBottom = y - pieceBoundingBox.minY();
            double densityFactor = 0.0;
            if (pieceTerrainAdaptation != EnhancedTerrainAdaptation.NONE) {
                densityFactor = pieceTerrainAdaptation.computeDensityFactor(xDistanceToBoundingBox, yDistanceToBoundingBox, zDistanceToBoundingBox, yDistanceToPieceBottom) * 0.8;
            }
            density += densityFactor;
        }
        data.getEnhancedPieceIterator().back(Integer.MAX_VALUE);
        while (data.getEnhancedJunctionIterator() != null && data.getEnhancedJunctionIterator().hasNext()) {
            EnhancedJigsawJunction enhancedJigsawJunction = (EnhancedJigsawJunction)data.getEnhancedJunctionIterator().next();
            JigsawJunction jigsawJunction = enhancedJigsawJunction.jigsawJunction();
            pieceTerrainAdaptation = enhancedJigsawJunction.pieceTerrainAdaptation();
            int groundY = jigsawJunction.getSourceGroundY() + (int)pieceTerrainAdaptation.getBottomOffset();
            int xDistanceToJunction = x - jigsawJunction.getSourceX();
            int yDistanceToJunction = y - groundY;
            int zDistanceToJunction = z - jigsawJunction.getSourceZ();
            density += pieceTerrainAdaptation.computeDensityFactor(xDistanceToJunction, yDistanceToJunction, zDistanceToJunction, yDistanceToJunction) * 0.4;
        }
        data.getEnhancedJunctionIterator().back(Integer.MAX_VALUE);
        return density;
    }
}

